% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_pool.R
\name{indProbs}
\alias{indProbs}
\title{Probability of contribution of each individual}
\usage{
indProbs(np, nSNPs, pError)
}
\arguments{
\item{np}{an integer specifying how many individuals were pooled.}

\item{nSNPs}{an integer indicating how many SNPs exist in the data.}

\item{pError}{an integer representing the value of the error associated with
DNA pooling. This value is related with the unequal individual contribution
towards the total number of reads contributed by a single pool - the higher
the value the more unequal are the individual contributions.}
}
\value{
a matrix with the probabilities of contribution for each individual.
Each row represents a different individual and each column is a different
site.
}
\description{
This function computes the probability of contribution for each individual of
a given pool. Please note that this function works for a single pool and
should not be directly applied to situations where multiple pools were used.
}
\examples{
# probability of contribution for 10 individuals at 5 sites
indProbs(np = 10, nSNPs = 5, pError = 100)

}
