% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_pool.R
\name{filterPool}
\alias{filterPool}
\title{Filter Pool-seq data according to a minor-allele reads threshold}
\usage{
filterPool(pool, nloci, min.minor)
}
\arguments{
\item{pool}{a list containing the "reference" element, representing the
number of reads with the reference allele, the "alternative" element
representing the number of reads with the alternative allele and the
"total" element that contains information about the total number of reads.}

\item{nloci}{an integer that represents the total number of independent loci
in the dataset.}

\item{min.minor}{is an integer representing the minimum allowed number of
minor-allele reads. Sites that, across all populations, have less
minor-allele reads than this threshold will be removed from the data.}
}
\value{
a list with three named entries:

\item{reference}{a list with one entry per locus. Each entry is a matrix with
the number of reference allele reads. Each column represents a different site.}

\item{alternative}{a list with one entry per locus. Each entry is a matrix with
the number of alternative allele reads. Each column represents a different site.}

\item{total}{a list with one entry per locus. Each entry is a matrix with
the total depth of coverage. Each column represents a different site.}
}
\description{
Removes sites from Pool-seq data. If a site has less minor-allele reads than
\code{min.minor} across all populations, that site is removed from the data.
}
\keyword{internal}
