% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_ABC.R
\name{simulationABC}
\alias{simulationABC}
\title{Perform an Approximate Bayesian Computation simulation study}
\usage{
simulationABC(
  params,
  sumstats,
  limits,
  nval,
  tol,
  method,
  parallel = FALSE,
  ncores = NA
)
}
\arguments{
\item{params}{is a vector or matrix of simulated parameter values i.e.
numbers from the simulations. Each row or vector entry should be a
different simulation and each column of a matrix should be a different
parameter. This is the dependent variable for the regression, if a
regression step is performed.}

\item{sumstats}{is a vector or matrix of simulated summary statistics. Each
row or vector entry should be a different simulation and each column of a
matrix should be a different statistic. These act as the independent
variables if a regression step is performed.}

\item{limits}{is a matrix with two columns and as many rows as there are
parameters. Each row should contain the minimum value of the prior for a
given parameter in the first column and the maximum value in the second
column.}

\item{nval}{size of the cross-validation sample i.e. how many different
evaluations should be performed. Each evaluation corresponds to a different
target for the parameter estimation.}

\item{tol}{is the tolerance rate, indicating the required proportion of
points accepted nearest the target values.}

\item{method}{either "rejection" or "regression" indicating whether a
regression step should be performed during ABC parameter estimation.}

\item{parallel}{logical, indicating whether this function should be run using
parallel execution. The default setting is FALSE, meaning that this
function will utilize a single core.}

\item{ncores}{a non-negative integer that is required when \code{parallel} is
TRUE. It specifies the number of cores to use for parallel execution.}
}
\value{
a list with the following elements:

\item{true}{The parameter values of the simulations that served as
validation.}

\item{rej}{a list with the estimated parameter values under the rejection
algorithm and using three different point estimates: mode, median and mean.
The final entry of the list is the prediction error for each parameter,
considering each of those point estimates as the estimated value.}

\item{reg}{if method is "regression" then this is a list with the estimated
parameter values under the regression algorithm and using three different
point estimates: mode, median and mean. The final entry of the list is the
prediction error for each parameter, considering each of those point
estimates as the estimated value.}
}
\description{
Perform a leave-one-out cross validation for ABC via subsequent calls to the
\code{\link[=singleABC]{singleABC()}} function.
}
\details{
This function allows users to evaluate the impact of different tolerance rate
on the quality of the estimation with ABC and whether a local linear
regression algorithm improves the estimates. In subsequent steps, different
point estimates of the posterior estimates can be compared with the true
values, allowing the users to select the point estimate that leads to lower
errors. Thus, performing a leave-one-out cross validation aids in selecting
which point estimate is best - the mean, median or mode.
}
\examples{
# load the matrix with parameter values
data(params)
# load the matrix with simulated parameter values
data(sumstats)
# load the matrix with the prior limits
data(limits)

# perform a leave-one-out cross validation for ABC
simulationABC(params = params, sumstats = sumstats, limits, nval = 10,
tol = 0.01, method = "regression")

}
