% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_ABC.R
\name{plot_error}
\alias{plot_error}
\title{Prediction error plots for ABC}
\usage{
plot_error(
  true,
  estimated,
  transformation = "none",
  param.name = NULL,
  main = NULL
)
}
\arguments{
\item{true}{is a numeric vector containing the true parameter values.}

\item{estimated}{a numeric vector containing the estimated parameter values.}

\item{transformation}{default is none. It can also be 'log' if you wish to
transform both the true and estimated values using a log10 scale.}

\item{param.name}{is an optional character input defining the name of the
parameter you are looking at.}

\item{main}{is a optional character argument that will be used as the title
for the plot. If this input argument is not included, this function will do
its best to create an appropriate title.}
}
\value{
a plot of the estimated value of the parameter (in the y-axis) versus
the true parameter value (in the x-axis). A line marking the correspondence
between the true and estimated values is also plotted. Thus, the closer the
points are to that line, the lower the prediction error is.
}
\description{
Plots the prediction error computed from a leave-one-out cross validation for
ABC parameter inference.
}
\details{
These plots help in visualizing the quality of the estimation and the effect
of the chosen tolerance level or point estimate statistic.
}
\keyword{internal}
