% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqData_wrappers.R
\name{DESeq2_wrapper}
\alias{DESeq2_wrapper}
\title{Wrapper for DESeq2 workflow}
\usage{
DESeq2_wrapper(
  omicsData,
  test = "Wald",
  p_adjust = "BH",
  comparisons = NULL,
  p_cutoff = 0.05,
  ...
)
}
\arguments{
\item{omicsData}{an object of type 'seqData', created by \code{\link{as.seqData}}}

\item{test}{either "Wald" or "LRT", which will then use either Wald
significance tests, or the likelihood ratio test on the difference in
deviance between a full and reduced model formula}

\item{p_adjust}{Character string for p-value correction method, refer to
?p.adjust() for valid options. Defaults to "BH" (Benjamini & Hochberg)}

\item{comparisons}{`data.frame` with columns for "Control" and "Test"
containing the different comparisons of interest. Comparisons will be made
between the Test and the corresponding Control  If left NULL, then all
pairwise comparisons are executed.}

\item{p_cutoff}{Numeric value between 0 and 1 for setting p-value
significance threshold}

\item{...}{additional arguments passed to function}
}
\value{
statRes object
}
\description{
For generating statistics for 'seqData' objects
}
\details{
Runs default DESeq workflow. Defaults to Wald test, no independent
  filtering, and running in parallel. Additional arguments can be passed for
  use in the function, refer to DESeq() and results() in DESeq2 package.
  Requires 'survival' package to run.

  Flags (signatures) -	Indicator of statistical significance for computed
  test. Zeros indicate no significance, while +/- 1 indicates direction of
  significance.
}
\references{
Love, M.I., Huber, W., Anders, S. Moderated estimation of fold change and
 dispersion for RNA-seq data with DESeq2 Genome Biology 15(12):550 (2014)
}
