% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_overlap_pScores.R
\name{plot_overlap_pScores}
\alias{plot_overlap_pScores}
\title{Plot the overlap via propensity score method}
\usage{
plot_overlap_pScores(
  .data,
  treatment,
  response,
  confounders,
  plot_type = c("histogram", "density"),
  pscores = NULL,
  ...
)
}
\arguments{
\item{.data}{dataframe}

\item{treatment}{character. Name of the treatment column within .data}

\item{response}{character. Name of the response column within .data}

\item{confounders}{character list of column names denoting confounders within .data}

\item{plot_type}{the plot type, one of c('Histogram', 'Density')}

\item{pscores}{propensity scores. If not provided, then propensity scores will be calculated using BART}

\item{\dots}{additional arguments passed to `bartCause::bartc` propensity score calculation}
}
\value{
ggplot object
}
\description{
Plot histograms showing the overlap between propensity scores by treatment status.
}
\examples{
\donttest{
data(lalonde)
plot_overlap_pScores(
 .data = lalonde,
 treatment = 'treat',
 response = 're78',
 confounders = c('age', 'educ'),
 plot_type = 'histogram',
 pscores = NULL,
 seed = 44
)
}
}
\seealso{
\code{\link{plot_overlap_vars}}
}
\author{
George Perrett, Joseph Marlo
}
