% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{separate_col}
\alias{separate_col}
\title{Turns a single character column into multiple columns.}
\usage{
separate_col(.data, col, into, sep = "[^[:alnum:]]+")
}
\arguments{
\item{.data}{A data frame}

\item{col}{Column name}

\item{into}{Names of new variables to create as character vector}

\item{sep}{The separator between columns. By default, a regular expression
that matches any sequence of non-alphanumeric values.}
}
\value{
A mutated \code{.data}
}
\description{
Given either a regular expression or a vector of character positions,
\code{separate_col()} turns a single character column into multiple columns.
}
\examples{
library(pliman)
df <- data.frame(x = paste0("TRAT_", 1:5),
                 y = 1:5)
df
separate_col(df, x, into = c("TRAT", "REP"))
}
