% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_landmarks.R
\name{landmarks_add}
\alias{landmarks_add}
\title{Artificially inflates the number of landmarks}
\usage{
landmarks_add(x, n = 3, smooth_iter = 0, plot = TRUE, nrow = NULL, ncol = NULL)
}
\arguments{
\item{x}{A \code{matrix}, a \code{data.frame} a \code{list} of perimeter coordinates, often
produced with \code{\link[=object_contour]{object_contour()}}, \code{\link[=landmarks]{landmarks()}}, or \code{\link[=landmarks_regradi]{landmarks_regradi()}}.}

\item{n}{The number of iterations. Defaults to 3.}

\item{smooth_iter}{The number of smoothing iterations to perform. This will
smooth the perimeter of the interpolated landmarks using \code{\link[=poly_smooth]{poly_smooth()}}.}

\item{plot}{Creates a plot? Defaults to \code{TRUE}.}

\item{ncol, nrow}{The number of rows or columns in the plot grid when a \code{list}
is used in \code{x}. Defaults to \code{NULL}, i.e., a square grid is produced.}
}
\value{
A Matrix of interpolated coordinates.
}
\description{
Interpolates supplementary landmarks that correspond to the mean coordinates
of two adjacent landmarks.
}
\examples{
library(pliman)

# equally spaced landmarks
plot_polygon(contours[[4]])
ldm <- landmarks_regradi(contours[[4]], plot = FALSE)
points(ldm$coords, pch = 16)
segments(mean(ldm$coords[,1]),
         mean(ldm$coords[,2]),
         ldm$coords[,1],
         ldm$coords[,2])

ldm_add <- landmarks_add(ldm, plot = FALSE)
points(ldm_add, col = "red")
points(ldm$coords, pch = 16)

# smoothed version
ldm_add_smo <- landmarks_add(ldm, plot = FALSE, smooth_iter = 10)
lines(ldm_add_smo, col = "blue", lwd = 3)
}
