% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mosaic.R
\name{mosaic_interpolate}
\alias{mosaic_interpolate}
\title{Mosaic interpolation}
\usage{
mosaic_interpolate(mosaic, points, method = c("bilinear", "loess", "idw"))
}
\arguments{
\item{mosaic}{An \code{SpatRaster} object}

\item{points}{An \code{sf} object with the points for x and y coordinates, usually
obtained with \code{\link[=shapefile_build]{shapefile_build()}}. Alternatively, an external shapefile
imported with \code{\link[=shapefile_input]{shapefile_input()}} containing the x and y coordinates can be
used. The function will handle most used shapefile formats (eg.,
.shp, .rds) and convert the imported shapefile to an sf object.}

\item{method}{One of "bilinear" (default), "loess" (local regression) or
"idw" (Inverse Distance Weighting).}
}
\value{
An \code{SpatRaster} object with the same extent and crs from \code{mosaic}
}
\description{
Performs the interpolation of points from a raster object.
}
