% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_imagem.R
\name{image_canny_edge}
\alias{image_canny_edge}
\title{Canny Edge Detector}
\usage{
image_canny_edge(img, index = "GRAY", s = 5, low_thr = 10, high_thr = 20)
}
\arguments{
\item{img}{An \code{Image} object.}

\item{index}{A character string with the index to be used. Defaults to \code{"GRAY"}.}

\item{s}{sigma, the Gaussian filter variance. Defaults to 5.}

\item{low_thr}{lower threshold value of the algorithm. Defaults to 10.}

\item{high_thr}{upper threshold value of the algorithm. Defaults to 20}
}
\value{
a list with an \code{Image} object with values 0 or 255, and the number of
pixels which have value 255 (pixels_nonzero).
}
\description{
Canny Edge Detector for Images. Adapted from \url{https://github.com/bnosac/image/tree/master/image.CannyEdges}.
}
\examples{
if(interactive()){
library(pliman)
img <- image_pliman("sev_leaf.jpg")
conts <- image_canny_edge(img, index = "B")
par(mfrow = c(1, 2))
plot(img)
plot(conts$edges)
par(mfrow = c(1, 1))
}
}
