% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dea-utils.R
\name{create_matrix}
\alias{create_matrix}
\title{Create a matrix for input or output variables}
\usage{
create_matrix(df, columns, id, normalize = FALSE)
}
\arguments{
\item{df}{A data.frame containing the data.}

\item{columns}{A character vector of column names to include in the matrix.}

\item{id}{A character string specifying the column with DMU IDs.}

\item{normalize}{A logical indicating whether to normalize the columns by their
mean. Defaults to \code{FALSE}.}
}
\value{
A matrix of inputs or outputs
}
\description{
Create a matrix for input or output variables that can be used in DEA models
from a supplied data.frame
}
\examples{
df <- data.frame(id = 1:3, a = c(10, 20, 30), b = c(5, 15, 25))
create_matrix(df, columns = c("a", "b"), id = "id", normalize = TRUE)

}
