% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projcov.R
\name{projcov}
\alias{projcov}
\title{Calculate the Projected Covariance of Two Vectors}
\usage{
projcov(
  x,
  y,
  b,
  method = c("lasso", "sam", "ols"),
  one.SE = TRUE,
  refit = TRUE,
  R = 199,
  randSeed = 0,
  normalized = FALSE
)
}
\arguments{
\item{x}{first vector}

\item{y}{second vector}

\item{b}{factor matrix}

\item{method}{projection method. Default = 'lasso'.}

\item{one.SE}{whether to use the 1se rule for glmnet. Default = TRUE.}

\item{refit}{whether to refit the selected model. Default = TRUE.}

\item{R}{number of random permutations for the test.}

\item{randSeed}{the random seed for the program. Default = 0.}

\item{normalized}{whether to normalized by S2. Default = FALSE.}
}
\value{
a list.
\item{test.pearson}{pearson correlection test statistic}
\item{test.dcov}{distance covariance test statistic}
\item{xeps}{residual of  projection of x on b}
\item{yeps}{residual of  projection of y on b}
}
\description{
\code{projcov} calculate the projected distance covariance of two vectors given
common factors.
}
\examples{
library(splines)
set.seed(0)
K = 3
n = 100
b = matrix(rnorm(K*n),n,K)
bx = 1:3
by = c(1,2,2)
x = b\%*\%bx+rnorm(n)
y = b\%*\%by+rnorm(n)
fit1 = projcov(x, y, b, method = 'lasso')
fit2 = projcov(x, y, b, method = 'sam')
}
\seealso{
\code{\link{greg}}, \code{\link{roc}}, \code{\link{pgraph}}
}
