% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rewireR.R
\name{rewireR}
\alias{rewireR}
\title{Rewire graph by randomly assigning new values for a given degree of perturbation.}
\usage{
rewireR(sym.matrix, nperturb, dist)
}
\arguments{
\item{sym.matrix}{A symmetric, sparse count matrix object.}

\item{nperturb}{The number of edges to randomly alter.}

\item{dist}{Option to rewire in a manner that retains overall graph weight regardless of distribution of edge weights. 
This option is invoked by putting any text into this field. Defaults to "NegBinom" for negative binomial.}
}
\description{
Randomly rewires graphs by altering a specific number of edges using Bernoulli 
trials as described in "The weighted random graph model" by Garlaschelli,
New Journal of Physics, 11, (2009), 073005. Only undirected, weigghted count matrices 
are considered here.
}
\examples{
rewireR(exampledata, nperturb=40, dist = "Normal")
}
