% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/requestAPI.R
\name{API_Request}
\alias{API_Request}
\title{Get Large Language Model Completions Endpoint}
\usage{
API_Request(
  prompt,
  PERPLEXITY_API_KEY = PERPLEXITY_API_KEY,
  modelSelection = modelSelection,
  systemRole = systemRole,
  maxTokens = maxTokens,
  temperature = temperature,
  top_p = top_p,
  top_k = top_k,
  presence_penalty = presence_penalty,
  frequency_penalty = frequency_penalty,
  proxy = proxy
)
}
\arguments{
\item{prompt}{The prompt to generate completions for.}

\item{PERPLEXITY_API_KEY}{PERPLEXITY API key.}

\item{modelSelection}{model choice. Default is mistral-7b-instruct.}

\item{systemRole}{Role for model. Default is: "You are a helpful assistant
with extensive knowledge of R programming."}

\item{maxTokens}{The maximum integer of completion tokens returned by API.}

\item{temperature}{The amount of randomness in the response,
valued between 0 inclusive and 2 exclusive. Higher values are more random,
and lower values are more deterministic. Set either temperature or top_p.}

\item{top_p}{Nucleus sampling threshold, valued between 0 and 1 inclusive.}

\item{top_k}{The number of tokens to keep for highest top-k filtering,
specified as an integer between 0 and 2048 inclusive.
If set to 0, top-k filtering is disabled.}

\item{presence_penalty}{A value between -2.0 and 2.0.
Positive values penalize new tokens based on whether they appear in the text
so far, increasing the model's likelihood to talk about new topics.
Incompatible with frequency_penalty.}

\item{frequency_penalty}{A multiplicative penalty greater than 0.
Values greater than 1.0 penalize new tokens based on their existing
frequency in the text so far, decreasing the model's likelihood to repeat
the same line verbatim. A value of 1.0 means no penalty.}

\item{proxy}{Default value is NULL.}
}
\description{
Get Large Language Model Completions Endpoint
}
