% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/placebo_test.R
\name{placebo_test}
\alias{placebo_test}
\alias{placebo_test.pensynth}
\alias{placebo_test.cvpensynth}
\title{Placebo permutation test for pensynth}
\usage{
placebo_test(object, Y1, Y0, verbose = TRUE)

\method{placebo_test}{pensynth}(object, Y1, Y0, verbose = TRUE)

\method{placebo_test}{cvpensynth}(object, Y1, Y0, verbose = TRUE)
}
\arguments{
\item{object}{a fitted \code{pensynth} or \code{cvpensynth} object}

\item{Y1}{the post-intervention outcome of the treated unit}

\item{Y0}{the post-intervention outcome of the donor units}

\item{verbose}{\code{boolean} whether to print progress messages. Default on if in an interactive session.
(with N_donors columns)}
}
\value{
A list with two elements
\itemize{
\item E1, the treated unit effect(s), computed as \code{Y1 - Y0 \%*\% w}
\item E0, the donor unit effects, computed in the same way but
using the permutation test's weights.
\item ATE1, the estimated ATE of the treated unit(s)
\item ATE0, the estimated ATE of the donor units
}
}
\description{
Perform a permutation test on a pensynth object, in the sense
of Abadie, Diamond, and Hainmueller (2010). The pensynth
method is performed multiple times, treating each donor as the
treated unit and the treated unit with the remaining donors as
the donor units.
}
\details{
Note that this function updates the original call in order to
re-estimate the synthetic control on the permuted data.
Ensure that the data is available to the placebo test function
(i.e., avoid complex environment functions such as \code{with()}),
and ensure that the data does not change between estimating the
original object and calling this function.
}
\examples{
set.seed(45)

# simulate data with an effect of 0.8 SD
dat <- simulate_data_synth(treatment_effect = .8)

# fit a model
fit <- pensynth(dat$X1, dat$X0, lambda = 1e-5)

# Perform placebo test
test <- placebo_test(fit, dat$Y1, dat$Y0)
plot(test)
abline(h = .8, lty = 2)
legend("bottomright", lty = 2, legend = "true effect")

# compute a pseudo p-value based on ATE in
# the post-intervention time period
ref_dist <- stats::ecdf(test$ATE0)
1 - ref_dist(test$ATE1)
}
\references{
Abadie, A., Diamond, A., & Hainmueller, J. (2010).
Synthetic control methods for comparative case studies:
Estimating the effect of California’s tobacco control program.
Journal of the American statistical Association, 105(490),
493-505.
}
\seealso{
\code{\link[=pensynth]{pensynth()}}, \code{\link[=cv_pensynth]{cv_pensynth()}}, \code{\link[=plot.pensynthtest]{plot.pensynthtest()}}, \code{\link[stats:update]{stats::update()}}
}
