% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{summary,penfa-method}
\alias{summary,penfa-method}
\title{Summary constructor for a \code{penfa} object}
\usage{
\S4method{summary}{penfa}(
  object,
  header = TRUE,
  estimates = TRUE,
  ci = TRUE,
  level = 0.95,
  nd = 3L,
  cutoff = 0.05,
  extra = TRUE
)
}
\arguments{
\item{object}{An object of class \code{penfa}, found as a result of a call
to \code{penfa}.}

\item{header}{Logical. If \code{TRUE}, the header section is printed. The
header contains relevant information about the data, the fitted model, the
optimization process, and the penalization strategy, including, for
instance, the employed penalties, the estimated effective degrees of
freedom (\emph{edf}), the optimal values of the tuning parameter(s), the
GBIC and many others.}

\item{estimates}{Logical. If \code{TRUE}, a section with the parameter
estimates is printed out.}

\item{ci}{Logical. If \code{TRUE}, confidence intervals are added to the
parameter estimates section.}

\item{level}{Logical. It denotes the significance level used for the
statistical tests.}

\item{nd}{Integer. It determines the number of digits after the decimal point
to be printed in the parameter estimates section.}

\item{cutoff}{Numeric. Standard errors and confidence intervals for the
penalized parameter estimates falling below the \code{cutoff} value are not
displayed. Confidence intervals for the parameters that have been penalized
and shrunken to zero must be treated with caution.}

\item{extra}{Logical. If \code{TRUE}, additional information on the model
are displayed.}
}
\value{
An object reporting a detailed summary of the estimated parameters
for a \code{penfa} model.
}
\description{
An S4 method printing a summary of the model parameter estimates for an
object of class \code{penfa}.
}
\examples{

data(ccdata)

syntax = 'help  =~   h1 + h2 + h3 + h4 + h5 + h6 + h7 + 0*v1 + v2 + v3 + v4 + v5
          voice =~ 0*h1 + h2 + h3 + h4 + h5 + h6 + h7 +   v1 + v2 + v3 + v4 + v5'

alasso_fit <- penfa(## factor model
                    model  = syntax,
                    data   = ccdata,
                    std.lv = TRUE,
                    ## penalization
                    pen.shrink = "alasso",
                    eta = list(shrink = c("lambda" = 0.01), diff = c("none" = 0)),
                    ## automatic procedure
                    strategy = "auto")

summary(alasso_fit)



}
\seealso{
\code{\link{penfa}}, \code{\link{penfa-class}}
}
