% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COLA.R
\name{generate_CSU_site}
\alias{generate_CSU_site}
\title{One-shot site summaries for COLA-GLMM}
\usage{
generate_CSU_site(df_site, x_names, intercept = TRUE)
}
\arguments{
\item{df_site}{Data frame for one site. Must include outcome column named `y`
and the fixed-effect covariates in `x_names`. If `intercept = TRUE`, the
function will add an `Intercept` column when missing.}

\item{x_names}{Character vector of fixed-effect names (binary covariates; may
include `"Intercept"` if `intercept = TRUE`).}

\item{intercept}{Logical; include a fixed intercept in the pattern matrix.}
}
\value{
A list with elements:
\itemize{
  \item `Ck`   (integer vector) pattern counts
  \item `Sk`   (numeric vector) sums of y per pattern
  \item `S2k`  (numeric vector) sums of y^2 per pattern
  \item `X0`   (matrix) pattern design matrix aligned to `Ck/Sk/S2k`
}
}
\description{
Produces the **lossless**, pattern-level sufficient statistics for a single site:
pattern counts `Ck`, outcome sums `Sk = \eqn{\sum y}`, squared sums `S2k = \eqn{\sum y^2}`, and the
corresponding pattern matrix `X0`. Works for both binomial and Poisson outcomes
(for Bernoulli, `S2k == Sk`).
}
\examples{
# df_site$y must exist; x_names are binary
# out <- generate_CSU_site(df_site, c("Intercept","age","sex"), intercept = TRUE)
}
\keyword{internal}
