% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{route53profiles}
\alias{route53profiles}
\title{Route 53 Profiles}
\usage{
route53profiles(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
With Amazon Route 53 Profiles you can share Route 53 configurations with
VPCs and AWS accounts
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- route53profiles(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.networking:route53profiles_associate_profile]{associate_profile} \tab Associates a Route 53 Profiles profile with a VPC\cr
\link[paws.networking:route53profiles_associate_resource_to_profile]{associate_resource_to_profile} \tab Associates a DNS reource configuration to a Route 53 Profile\cr
\link[paws.networking:route53profiles_create_profile]{create_profile} \tab Creates an empty Route 53 Profile\cr
\link[paws.networking:route53profiles_delete_profile]{delete_profile} \tab Deletes the specified Route 53 Profile\cr
\link[paws.networking:route53profiles_disassociate_profile]{disassociate_profile} \tab Dissociates a specified Route 53 Profile from the specified VPC\cr
\link[paws.networking:route53profiles_disassociate_resource_from_profile]{disassociate_resource_from_profile} \tab Dissoaciated a specified resource, from the Route 53 Profile\cr
\link[paws.networking:route53profiles_get_profile]{get_profile} \tab Returns information about a specified Route 53 Profile, such as whether whether the Profile is shared, and the current status of the Profile\cr
\link[paws.networking:route53profiles_get_profile_association]{get_profile_association} \tab Retrieves a Route 53 Profile association for a VPC\cr
\link[paws.networking:route53profiles_get_profile_resource_association]{get_profile_resource_association} \tab Returns information about a specified Route 53 Profile resource association\cr
\link[paws.networking:route53profiles_list_profile_associations]{list_profile_associations} \tab Lists all the VPCs that the specified Route 53 Profile is associated with\cr
\link[paws.networking:route53profiles_list_profile_resource_associations]{list_profile_resource_associations} \tab Lists all the resource associations for the specified Route 53 Profile\cr
\link[paws.networking:route53profiles_list_profiles]{list_profiles} \tab Lists all the Route 53 Profiles associated with your Amazon Web Services account\cr
\link[paws.networking:route53profiles_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags that you associated with the specified resource\cr
\link[paws.networking:route53profiles_tag_resource]{tag_resource} \tab Adds one or more tags to a specified resource\cr
\link[paws.networking:route53profiles_untag_resource]{untag_resource} \tab Removes one or more tags from a specified resource\cr
\link[paws.networking:route53profiles_update_profile_resource_association]{update_profile_resource_association} \tab Updates the specified Route 53 Profile resourse association
}
}

\examples{
\dontrun{
svc <- route53profiles()
svc$associate_profile(
  Foo = 123
)
}

}
