% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{networkmanager}
\alias{networkmanager}
\title{AWS Network Manager}
\usage{
networkmanager(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Amazon Web Services enables you to centrally manage your Amazon Web
Services Cloud WAN core network and your Transit Gateway network across
Amazon Web Services accounts, Regions, and on-premises locations.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- networkmanager(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.networking:networkmanager_accept_attachment]{accept_attachment} \tab Accepts a core network attachment request\cr
\link[paws.networking:networkmanager_associate_connect_peer]{associate_connect_peer} \tab Associates a core network Connect peer with a device and optionally, with a link\cr
\link[paws.networking:networkmanager_associate_customer_gateway]{associate_customer_gateway} \tab Associates a customer gateway with a device and optionally, with a link\cr
\link[paws.networking:networkmanager_associate_link]{associate_link} \tab Associates a link to a device\cr
\link[paws.networking:networkmanager_associate_transit_gateway_connect_peer]{associate_transit_gateway_connect_peer} \tab Associates a transit gateway Connect peer with a device, and optionally, with a link\cr
\link[paws.networking:networkmanager_create_connect_attachment]{create_connect_attachment} \tab Creates a core network Connect attachment from a specified core network attachment\cr
\link[paws.networking:networkmanager_create_connection]{create_connection} \tab Creates a connection between two devices\cr
\link[paws.networking:networkmanager_create_connect_peer]{create_connect_peer} \tab Creates a core network Connect peer for a specified core network connect attachment between a core network and an appliance\cr
\link[paws.networking:networkmanager_create_core_network]{create_core_network} \tab Creates a core network as part of your global network, and optionally, with a core network policy\cr
\link[paws.networking:networkmanager_create_device]{create_device} \tab Creates a new device in a global network\cr
\link[paws.networking:networkmanager_create_direct_connect_gateway_attachment]{create_direct_connect_gateway_attachment} \tab Creates an Amazon Web Services Direct Connect gateway attachment\cr
\link[paws.networking:networkmanager_create_global_network]{create_global_network} \tab Creates a new, empty global network\cr
\link[paws.networking:networkmanager_create_link]{create_link} \tab Creates a new link for a specified site\cr
\link[paws.networking:networkmanager_create_site]{create_site} \tab Creates a new site in a global network\cr
\link[paws.networking:networkmanager_create_site_to_site_vpn_attachment]{create_site_to_site_vpn_attachment} \tab Creates an Amazon Web Services site-to-site VPN attachment on an edge location of a core network\cr
\link[paws.networking:networkmanager_create_transit_gateway_peering]{create_transit_gateway_peering} \tab Creates a transit gateway peering connection\cr
\link[paws.networking:networkmanager_create_transit_gateway_route_table_attachment]{create_transit_gateway_route_table_attachment} \tab Creates a transit gateway route table attachment\cr
\link[paws.networking:networkmanager_create_vpc_attachment]{create_vpc_attachment} \tab Creates a VPC attachment on an edge location of a core network\cr
\link[paws.networking:networkmanager_delete_attachment]{delete_attachment} \tab Deletes an attachment\cr
\link[paws.networking:networkmanager_delete_connection]{delete_connection} \tab Deletes the specified connection in your global network\cr
\link[paws.networking:networkmanager_delete_connect_peer]{delete_connect_peer} \tab Deletes a Connect peer\cr
\link[paws.networking:networkmanager_delete_core_network]{delete_core_network} \tab Deletes a core network along with all core network policies\cr
\link[paws.networking:networkmanager_delete_core_network_policy_version]{delete_core_network_policy_version} \tab Deletes a policy version from a core network\cr
\link[paws.networking:networkmanager_delete_device]{delete_device} \tab Deletes an existing device\cr
\link[paws.networking:networkmanager_delete_global_network]{delete_global_network} \tab Deletes an existing global network\cr
\link[paws.networking:networkmanager_delete_link]{delete_link} \tab Deletes an existing link\cr
\link[paws.networking:networkmanager_delete_peering]{delete_peering} \tab Deletes an existing peering connection\cr
\link[paws.networking:networkmanager_delete_resource_policy]{delete_resource_policy} \tab Deletes a resource policy for the specified resource\cr
\link[paws.networking:networkmanager_delete_site]{delete_site} \tab Deletes an existing site\cr
\link[paws.networking:networkmanager_deregister_transit_gateway]{deregister_transit_gateway} \tab Deregisters a transit gateway from your global network\cr
\link[paws.networking:networkmanager_describe_global_networks]{describe_global_networks} \tab Describes one or more global networks\cr
\link[paws.networking:networkmanager_disassociate_connect_peer]{disassociate_connect_peer} \tab Disassociates a core network Connect peer from a device and a link\cr
\link[paws.networking:networkmanager_disassociate_customer_gateway]{disassociate_customer_gateway} \tab Disassociates a customer gateway from a device and a link\cr
\link[paws.networking:networkmanager_disassociate_link]{disassociate_link} \tab Disassociates an existing device from a link\cr
\link[paws.networking:networkmanager_disassociate_transit_gateway_connect_peer]{disassociate_transit_gateway_connect_peer} \tab Disassociates a transit gateway Connect peer from a device and link\cr
\link[paws.networking:networkmanager_execute_core_network_change_set]{execute_core_network_change_set} \tab Executes a change set on your core network\cr
\link[paws.networking:networkmanager_get_connect_attachment]{get_connect_attachment} \tab Returns information about a core network Connect attachment\cr
\link[paws.networking:networkmanager_get_connections]{get_connections} \tab Gets information about one or more of your connections in a global network\cr
\link[paws.networking:networkmanager_get_connect_peer]{get_connect_peer} \tab Returns information about a core network Connect peer\cr
\link[paws.networking:networkmanager_get_connect_peer_associations]{get_connect_peer_associations} \tab Returns information about a core network Connect peer associations\cr
\link[paws.networking:networkmanager_get_core_network]{get_core_network} \tab Returns information about the LIVE policy for a core network\cr
\link[paws.networking:networkmanager_get_core_network_change_events]{get_core_network_change_events} \tab Returns information about a core network change event\cr
\link[paws.networking:networkmanager_get_core_network_change_set]{get_core_network_change_set} \tab Returns a change set between the LIVE core network policy and a submitted policy\cr
\link[paws.networking:networkmanager_get_core_network_policy]{get_core_network_policy} \tab Returns details about a core network policy\cr
\link[paws.networking:networkmanager_get_customer_gateway_associations]{get_customer_gateway_associations} \tab Gets the association information for customer gateways that are associated with devices and links in your global network\cr
\link[paws.networking:networkmanager_get_devices]{get_devices} \tab Gets information about one or more of your devices in a global network\cr
\link[paws.networking:networkmanager_get_direct_connect_gateway_attachment]{get_direct_connect_gateway_attachment} \tab Returns information about a specific Amazon Web Services Direct Connect gateway attachment\cr
\link[paws.networking:networkmanager_get_link_associations]{get_link_associations} \tab Gets the link associations for a device or a link\cr
\link[paws.networking:networkmanager_get_links]{get_links} \tab Gets information about one or more links in a specified global network\cr
\link[paws.networking:networkmanager_get_network_resource_counts]{get_network_resource_counts} \tab Gets the count of network resources, by resource type, for the specified global network\cr
\link[paws.networking:networkmanager_get_network_resource_relationships]{get_network_resource_relationships} \tab Gets the network resource relationships for the specified global network\cr
\link[paws.networking:networkmanager_get_network_resources]{get_network_resources} \tab Describes the network resources for the specified global network\cr
\link[paws.networking:networkmanager_get_network_routes]{get_network_routes} \tab Gets the network routes of the specified global network\cr
\link[paws.networking:networkmanager_get_network_telemetry]{get_network_telemetry} \tab Gets the network telemetry of the specified global network\cr
\link[paws.networking:networkmanager_get_resource_policy]{get_resource_policy} \tab Returns information about a resource policy\cr
\link[paws.networking:networkmanager_get_route_analysis]{get_route_analysis} \tab Gets information about the specified route analysis\cr
\link[paws.networking:networkmanager_get_sites]{get_sites} \tab Gets information about one or more of your sites in a global network\cr
\link[paws.networking:networkmanager_get_site_to_site_vpn_attachment]{get_site_to_site_vpn_attachment} \tab Returns information about a site-to-site VPN attachment\cr
\link[paws.networking:networkmanager_get_transit_gateway_connect_peer_associations]{get_transit_gateway_connect_peer_associations} \tab Gets information about one or more of your transit gateway Connect peer associations in a global network\cr
\link[paws.networking:networkmanager_get_transit_gateway_peering]{get_transit_gateway_peering} \tab Returns information about a transit gateway peer\cr
\link[paws.networking:networkmanager_get_transit_gateway_registrations]{get_transit_gateway_registrations} \tab Gets information about the transit gateway registrations in a specified global network\cr
\link[paws.networking:networkmanager_get_transit_gateway_route_table_attachment]{get_transit_gateway_route_table_attachment} \tab Returns information about a transit gateway route table attachment\cr
\link[paws.networking:networkmanager_get_vpc_attachment]{get_vpc_attachment} \tab Returns information about a VPC attachment\cr
\link[paws.networking:networkmanager_list_attachments]{list_attachments} \tab Returns a list of core network attachments\cr
\link[paws.networking:networkmanager_list_connect_peers]{list_connect_peers} \tab Returns a list of core network Connect peers\cr
\link[paws.networking:networkmanager_list_core_network_policy_versions]{list_core_network_policy_versions} \tab Returns a list of core network policy versions\cr
\link[paws.networking:networkmanager_list_core_networks]{list_core_networks} \tab Returns a list of owned and shared core networks\cr
\link[paws.networking:networkmanager_list_organization_service_access_status]{list_organization_service_access_status} \tab Gets the status of the Service Linked Role (SLR) deployment for the accounts in a given Amazon Web Services Organization\cr
\link[paws.networking:networkmanager_list_peerings]{list_peerings} \tab Lists the peerings for a core network\cr
\link[paws.networking:networkmanager_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags for a specified resource\cr
\link[paws.networking:networkmanager_put_core_network_policy]{put_core_network_policy} \tab Creates a new, immutable version of a core network policy\cr
\link[paws.networking:networkmanager_put_resource_policy]{put_resource_policy} \tab Creates or updates a resource policy\cr
\link[paws.networking:networkmanager_register_transit_gateway]{register_transit_gateway} \tab Registers a transit gateway in your global network\cr
\link[paws.networking:networkmanager_reject_attachment]{reject_attachment} \tab Rejects a core network attachment request\cr
\link[paws.networking:networkmanager_restore_core_network_policy_version]{restore_core_network_policy_version} \tab Restores a previous policy version as a new, immutable version of a core network policy\cr
\link[paws.networking:networkmanager_start_organization_service_access_update]{start_organization_service_access_update} \tab Enables the Network Manager service for an Amazon Web Services Organization\cr
\link[paws.networking:networkmanager_start_route_analysis]{start_route_analysis} \tab Starts analyzing the routing path between the specified source and destination\cr
\link[paws.networking:networkmanager_tag_resource]{tag_resource} \tab Tags a specified resource\cr
\link[paws.networking:networkmanager_untag_resource]{untag_resource} \tab Removes tags from a specified resource\cr
\link[paws.networking:networkmanager_update_connection]{update_connection} \tab Updates the information for an existing connection\cr
\link[paws.networking:networkmanager_update_core_network]{update_core_network} \tab Updates the description of a core network\cr
\link[paws.networking:networkmanager_update_device]{update_device} \tab Updates the details for an existing device\cr
\link[paws.networking:networkmanager_update_direct_connect_gateway_attachment]{update_direct_connect_gateway_attachment} \tab Updates the edge locations associated with an Amazon Web Services Direct Connect gateway attachment\cr
\link[paws.networking:networkmanager_update_global_network]{update_global_network} \tab Updates an existing global network\cr
\link[paws.networking:networkmanager_update_link]{update_link} \tab Updates the details for an existing link\cr
\link[paws.networking:networkmanager_update_network_resource_metadata]{update_network_resource_metadata} \tab Updates the resource metadata for the specified global network\cr
\link[paws.networking:networkmanager_update_site]{update_site} \tab Updates the information for an existing site\cr
\link[paws.networking:networkmanager_update_vpc_attachment]{update_vpc_attachment} \tab Updates a VPC attachment
}
}

\examples{
\dontrun{
svc <- networkmanager()
svc$accept_attachment(
  Foo = 123
)
}

}
