% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{codecatalyst}
\alias{codecatalyst}
\title{Amazon CodeCatalyst}
\usage{
codecatalyst(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Welcome to the Amazon CodeCatalyst API reference. This reference
provides descriptions of operations and data types for Amazon
CodeCatalyst. You can use the Amazon CodeCatalyst API to work with the
following objects.

Spaces, by calling the following:
\itemize{
\item \code{delete_space}, which deletes a space.
\item \code{get_space}, which returns information
about a space.
\item \code{get_subscription}, which returns
information about the Amazon Web Services account used for billing
purposes and the billing plan for the space.
\item \code{list_spaces}, which retrieves a list of
spaces.
\item \code{update_space}, which changes one or
more values for a space.
}

Projects, by calling the following:
\itemize{
\item \code{create_project} which creates a
project in a specified space.
\item \code{get_project}, which returns information
about a project.
\item \code{list_projects}, which retrieves a
list of projects in a space.
}

Users, by calling the following:
\itemize{
\item \code{get_user_details}, which returns
information about a user in Amazon CodeCatalyst.
}

Source repositories, by calling the following:
\itemize{
\item \code{create_source_repository},
which creates an empty Git-based source repository in a specified
project.
\item \code{create_source_repository_branch},
which creates a branch in a specified repository where you can work
on code.
\item \code{delete_source_repository},
which deletes a source repository.
\item \code{get_source_repository}, which
returns information about a source repository.
\item \code{get_source_repository_clone_urls},
which returns information about the URLs that can be used with a Git
client to clone a source repository.
\item \code{list_source_repositories},
which retrieves a list of source repositories in a project.
\item \code{list_source_repository_branches},
which retrieves a list of branches in a source repository.
}

Dev Environments and the Amazon Web Services Toolkits, by calling the
following:
\itemize{
\item \code{create_dev_environment},
which creates a Dev Environment, where you can quickly work on the
code stored in the source repositories of your project.
\item \code{delete_dev_environment},
which deletes a Dev Environment.
\item \code{get_dev_environment}, which
returns information about a Dev Environment.
\item \code{list_dev_environments}, which
retrieves a list of Dev Environments in a project.
\item \code{list_dev_environment_sessions},
which retrieves a list of active Dev Environment sessions in a
project.
\item \code{start_dev_environment}, which
starts a specified Dev Environment and puts it into an active state.
\item \code{start_dev_environment_session},
which starts a session to a specified Dev Environment.
\item \code{stop_dev_environment}, which
stops a specified Dev Environment and puts it into an stopped state.
\item \code{stop_dev_environment_session},
which stops a session for a specified Dev Environment.
\item \code{update_dev_environment},
which changes one or more values for a Dev Environment.
}

Workflows, by calling the following:
\itemize{
\item \code{get_workflow}, which returns
information about a workflow.
\item \code{get_workflow_run}, which returns
information about a specified run of a workflow.
\item \code{list_workflow_runs}, which
retrieves a list of runs of a specified workflow.
\item \code{list_workflows}, which retrieves a
list of workflows in a specified project.
\item \code{start_workflow_run}, which
starts a run of a specified workflow.
}

Security, activity, and resource management in Amazon CodeCatalyst, by
calling the following:
\itemize{
\item \code{create_access_token}, which
creates a personal access token (PAT) for the current user.
\item \code{delete_access_token}, which
deletes a specified personal access token (PAT).
\item \code{list_access_tokens}, which lists
all personal access tokens (PATs) associated with a user.
\item \code{list_event_logs}, which retrieves a
list of events that occurred during a specified time period in a
space.
\item \code{verify_session}, which verifies
whether the calling user has a valid Amazon CodeCatalyst login and
session.
}

If you are using the Amazon CodeCatalyst APIs with an SDK or the CLI,
you must configure your computer to work with Amazon CodeCatalyst and
single sign-on (SSO). For more information, see \href{https://docs.aws.amazon.com/codecatalyst/latest/userguide/set-up-cli.html}{Setting up to use the CLI with Amazon CodeCatalyst}
and the SSO documentation for your SDK.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- codecatalyst(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.developer.tools:codecatalyst_create_access_token]{create_access_token} \tab Creates a personal access token (PAT) for the current user\cr
\link[paws.developer.tools:codecatalyst_create_dev_environment]{create_dev_environment} \tab Creates a Dev Environment in Amazon CodeCatalyst, a cloud-based development environment that you can use to quickly work on the code stored in the source repositories of your project\cr
\link[paws.developer.tools:codecatalyst_create_project]{create_project} \tab Creates a project in a specified space\cr
\link[paws.developer.tools:codecatalyst_create_source_repository]{create_source_repository} \tab Creates an empty Git-based source repository in a specified project\cr
\link[paws.developer.tools:codecatalyst_create_source_repository_branch]{create_source_repository_branch} \tab Creates a branch in a specified source repository in Amazon CodeCatalyst\cr
\link[paws.developer.tools:codecatalyst_delete_access_token]{delete_access_token} \tab Deletes a specified personal access token (PAT)\cr
\link[paws.developer.tools:codecatalyst_delete_dev_environment]{delete_dev_environment} \tab Deletes a Dev Environment\cr
\link[paws.developer.tools:codecatalyst_delete_project]{delete_project} \tab Deletes a project in a space\cr
\link[paws.developer.tools:codecatalyst_delete_source_repository]{delete_source_repository} \tab Deletes a source repository in Amazon CodeCatalyst\cr
\link[paws.developer.tools:codecatalyst_delete_space]{delete_space} \tab Deletes a space\cr
\link[paws.developer.tools:codecatalyst_get_dev_environment]{get_dev_environment} \tab Returns information about a Dev Environment for a source repository in a project\cr
\link[paws.developer.tools:codecatalyst_get_project]{get_project} \tab Returns information about a project\cr
\link[paws.developer.tools:codecatalyst_get_source_repository]{get_source_repository} \tab Returns information about a source repository\cr
\link[paws.developer.tools:codecatalyst_get_source_repository_clone_urls]{get_source_repository_clone_urls} \tab Returns information about the URLs that can be used with a Git client to clone a source repository\cr
\link[paws.developer.tools:codecatalyst_get_space]{get_space} \tab Returns information about an space\cr
\link[paws.developer.tools:codecatalyst_get_subscription]{get_subscription} \tab Returns information about the Amazon Web Services account used for billing purposes and the billing plan for the space\cr
\link[paws.developer.tools:codecatalyst_get_user_details]{get_user_details} \tab Returns information about a user\cr
\link[paws.developer.tools:codecatalyst_get_workflow]{get_workflow} \tab Returns information about a workflow\cr
\link[paws.developer.tools:codecatalyst_get_workflow_run]{get_workflow_run} \tab Returns information about a specified run of a workflow\cr
\link[paws.developer.tools:codecatalyst_list_access_tokens]{list_access_tokens} \tab Lists all personal access tokens (PATs) associated with the user who calls the API\cr
\link[paws.developer.tools:codecatalyst_list_dev_environments]{list_dev_environments} \tab Retrieves a list of Dev Environments in a project\cr
\link[paws.developer.tools:codecatalyst_list_dev_environment_sessions]{list_dev_environment_sessions} \tab Retrieves a list of active sessions for a Dev Environment in a project\cr
\link[paws.developer.tools:codecatalyst_list_event_logs]{list_event_logs} \tab Retrieves a list of events that occurred during a specific time in a space\cr
\link[paws.developer.tools:codecatalyst_list_projects]{list_projects} \tab Retrieves a list of projects\cr
\link[paws.developer.tools:codecatalyst_list_source_repositories]{list_source_repositories} \tab Retrieves a list of source repositories in a project\cr
\link[paws.developer.tools:codecatalyst_list_source_repository_branches]{list_source_repository_branches} \tab Retrieves a list of branches in a specified source repository\cr
\link[paws.developer.tools:codecatalyst_list_spaces]{list_spaces} \tab Retrieves a list of spaces\cr
\link[paws.developer.tools:codecatalyst_list_workflow_runs]{list_workflow_runs} \tab Retrieves a list of workflow runs of a specified workflow\cr
\link[paws.developer.tools:codecatalyst_list_workflows]{list_workflows} \tab Retrieves a list of workflows in a specified project\cr
\link[paws.developer.tools:codecatalyst_start_dev_environment]{start_dev_environment} \tab Starts a specified Dev Environment and puts it into an active state\cr
\link[paws.developer.tools:codecatalyst_start_dev_environment_session]{start_dev_environment_session} \tab Starts a session for a specified Dev Environment\cr
\link[paws.developer.tools:codecatalyst_start_workflow_run]{start_workflow_run} \tab Begins a run of a specified workflow\cr
\link[paws.developer.tools:codecatalyst_stop_dev_environment]{stop_dev_environment} \tab Pauses a specified Dev Environment and places it in a non-running state\cr
\link[paws.developer.tools:codecatalyst_stop_dev_environment_session]{stop_dev_environment_session} \tab Stops a session for a specified Dev Environment\cr
\link[paws.developer.tools:codecatalyst_update_dev_environment]{update_dev_environment} \tab Changes one or more values for a Dev Environment\cr
\link[paws.developer.tools:codecatalyst_update_project]{update_project} \tab Changes one or more values for a project\cr
\link[paws.developer.tools:codecatalyst_update_space]{update_space} \tab Changes one or more values for a space\cr
\link[paws.developer.tools:codecatalyst_verify_session]{verify_session} \tab Verifies whether the calling user has a valid Amazon CodeCatalyst login and session
}
}

\examples{
\dontrun{
svc <- codecatalyst()
svc$create_access_token(
  Foo = 123
)
}

}
