% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_create_resolver_rule}
\alias{route53resolver_create_resolver_rule}
\title{For DNS queries that originate in your VPCs, specifies which Resolver
endpoint the queries pass through, one domain name that you want to
forward to your network, and the IP addresses of the DNS resolvers in
your network}
\usage{
route53resolver_create_resolver_rule(
  CreatorRequestId,
  Name = NULL,
  RuleType,
  DomainName = NULL,
  TargetIps = NULL,
  ResolverEndpointId = NULL,
  Tags = NULL
)
}
\arguments{
\item{CreatorRequestId}{[required] A unique string that identifies the request and that allows failed
requests to be retried without the risk of running the operation twice.
\code{CreatorRequestId} can be any unique string, for example, a date/time
stamp.}

\item{Name}{A friendly name that lets you easily find a rule in the Resolver
dashboard in the Route 53 console.}

\item{RuleType}{[required] When you want to forward DNS queries for specified domain name to
resolvers on your network, specify \code{FORWARD}.

When you have a forwarding rule to forward DNS queries for a domain to
your network and you want Resolver to process queries for a subdomain of
that domain, specify \code{SYSTEM}.

For example, to forward DNS queries for example.com to resolvers on your
network, you create a rule and specify \code{FORWARD} for \code{RuleType}. To then
have Resolver process queries for apex.example.com, you create a rule
and specify \code{SYSTEM} for \code{RuleType}.

Currently, only Resolver can create rules that have a value of
\code{RECURSIVE} for \code{RuleType}.}

\item{DomainName}{DNS queries for this domain name are forwarded to the IP addresses that
you specify in \code{TargetIps}. If a query matches multiple Resolver rules
(example.com and www.example.com), outbound DNS queries are routed using
the Resolver rule that contains the most specific domain name
(www.example.com).}

\item{TargetIps}{The IPs that you want Resolver to forward DNS queries to. You can
specify either Ipv4 or Ipv6 addresses but not both in the same rule.
Separate IP addresses with a space.

\code{TargetIps} is available only when the value of \verb{Rule type} is
\code{FORWARD}.}

\item{ResolverEndpointId}{The ID of the outbound Resolver endpoint that you want to use to route
DNS queries to the IP addresses that you specify in \code{TargetIps}.}

\item{Tags}{A list of the tag keys and values that you want to associate with the
endpoint.}
}
\description{
For DNS queries that originate in your VPCs, specifies which Resolver endpoint the queries pass through, one domain name that you want to forward to your network, and the IP addresses of the DNS resolvers in your network.

See \url{https://www.paws-r-sdk.com/docs/route53resolver_create_resolver_rule/} for full documentation.
}
\keyword{internal}
