# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AmazonApiGatewayV2
#'
#' @description
#' Amazon API Gateway V2
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- apigatewayv2(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- apigatewayv2()
#' svc$create_api(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=apigatewayv2_create_api]{create_api} \tab Creates an Api resource\cr
#'  \link[=apigatewayv2_create_api_mapping]{create_api_mapping} \tab Creates an API mapping\cr
#'  \link[=apigatewayv2_create_authorizer]{create_authorizer} \tab Creates an Authorizer for an API\cr
#'  \link[=apigatewayv2_create_deployment]{create_deployment} \tab Creates a Deployment for an API\cr
#'  \link[=apigatewayv2_create_domain_name]{create_domain_name} \tab Creates a domain name\cr
#'  \link[=apigatewayv2_create_integration]{create_integration} \tab Creates an Integration\cr
#'  \link[=apigatewayv2_create_integration_response]{create_integration_response} \tab Creates an IntegrationResponses\cr
#'  \link[=apigatewayv2_create_model]{create_model} \tab Creates a Model for an API\cr
#'  \link[=apigatewayv2_create_route]{create_route} \tab Creates a Route for an API\cr
#'  \link[=apigatewayv2_create_route_response]{create_route_response} \tab Creates a RouteResponse for a Route\cr
#'  \link[=apigatewayv2_create_stage]{create_stage} \tab Creates a Stage for an API\cr
#'  \link[=apigatewayv2_create_vpc_link]{create_vpc_link} \tab Creates a VPC link\cr
#'  \link[=apigatewayv2_delete_access_log_settings]{delete_access_log_settings} \tab Deletes the AccessLogSettings for a Stage\cr
#'  \link[=apigatewayv2_delete_api]{delete_api} \tab Deletes an Api resource\cr
#'  \link[=apigatewayv2_delete_api_mapping]{delete_api_mapping} \tab Deletes an API mapping\cr
#'  \link[=apigatewayv2_delete_authorizer]{delete_authorizer} \tab Deletes an Authorizer\cr
#'  \link[=apigatewayv2_delete_cors_configuration]{delete_cors_configuration} \tab Deletes a CORS configuration\cr
#'  \link[=apigatewayv2_delete_deployment]{delete_deployment} \tab Deletes a Deployment\cr
#'  \link[=apigatewayv2_delete_domain_name]{delete_domain_name} \tab Deletes a domain name\cr
#'  \link[=apigatewayv2_delete_integration]{delete_integration} \tab Deletes an Integration\cr
#'  \link[=apigatewayv2_delete_integration_response]{delete_integration_response} \tab Deletes an IntegrationResponses\cr
#'  \link[=apigatewayv2_delete_model]{delete_model} \tab Deletes a Model\cr
#'  \link[=apigatewayv2_delete_route]{delete_route} \tab Deletes a Route\cr
#'  \link[=apigatewayv2_delete_route_request_parameter]{delete_route_request_parameter} \tab Deletes a route request parameter\cr
#'  \link[=apigatewayv2_delete_route_response]{delete_route_response} \tab Deletes a RouteResponse\cr
#'  \link[=apigatewayv2_delete_route_settings]{delete_route_settings} \tab Deletes the RouteSettings for a stage\cr
#'  \link[=apigatewayv2_delete_stage]{delete_stage} \tab Deletes a Stage\cr
#'  \link[=apigatewayv2_delete_vpc_link]{delete_vpc_link} \tab Deletes a VPC link\cr
#'  \link[=apigatewayv2_export_api]{export_api} \tab Export api\cr
#'  \link[=apigatewayv2_get_api]{get_api} \tab Gets an Api resource\cr
#'  \link[=apigatewayv2_get_api_mapping]{get_api_mapping} \tab Gets an API mapping\cr
#'  \link[=apigatewayv2_get_api_mappings]{get_api_mappings} \tab Gets API mappings\cr
#'  \link[=apigatewayv2_get_apis]{get_apis} \tab Gets a collection of Api resources\cr
#'  \link[=apigatewayv2_get_authorizer]{get_authorizer} \tab Gets an Authorizer\cr
#'  \link[=apigatewayv2_get_authorizers]{get_authorizers} \tab Gets the Authorizers for an API\cr
#'  \link[=apigatewayv2_get_deployment]{get_deployment} \tab Gets a Deployment\cr
#'  \link[=apigatewayv2_get_deployments]{get_deployments} \tab Gets the Deployments for an API\cr
#'  \link[=apigatewayv2_get_domain_name]{get_domain_name} \tab Gets a domain name\cr
#'  \link[=apigatewayv2_get_domain_names]{get_domain_names} \tab Gets the domain names for an AWS account\cr
#'  \link[=apigatewayv2_get_integration]{get_integration} \tab Gets an Integration\cr
#'  \link[=apigatewayv2_get_integration_response]{get_integration_response} \tab Gets an IntegrationResponses\cr
#'  \link[=apigatewayv2_get_integration_responses]{get_integration_responses} \tab Gets the IntegrationResponses for an Integration\cr
#'  \link[=apigatewayv2_get_integrations]{get_integrations} \tab Gets the Integrations for an API\cr
#'  \link[=apigatewayv2_get_model]{get_model} \tab Gets a Model\cr
#'  \link[=apigatewayv2_get_models]{get_models} \tab Gets the Models for an API\cr
#'  \link[=apigatewayv2_get_model_template]{get_model_template} \tab Gets a model template\cr
#'  \link[=apigatewayv2_get_route]{get_route} \tab Gets a Route\cr
#'  \link[=apigatewayv2_get_route_response]{get_route_response} \tab Gets a RouteResponse\cr
#'  \link[=apigatewayv2_get_route_responses]{get_route_responses} \tab Gets the RouteResponses for a Route\cr
#'  \link[=apigatewayv2_get_routes]{get_routes} \tab Gets the Routes for an API\cr
#'  \link[=apigatewayv2_get_stage]{get_stage} \tab Gets a Stage\cr
#'  \link[=apigatewayv2_get_stages]{get_stages} \tab Gets the Stages for an API\cr
#'  \link[=apigatewayv2_get_tags]{get_tags} \tab Gets a collection of Tag resources\cr
#'  \link[=apigatewayv2_get_vpc_link]{get_vpc_link} \tab Gets a VPC link\cr
#'  \link[=apigatewayv2_get_vpc_links]{get_vpc_links} \tab Gets a collection of VPC links\cr
#'  \link[=apigatewayv2_import_api]{import_api} \tab Imports an API\cr
#'  \link[=apigatewayv2_reimport_api]{reimport_api} \tab Puts an Api resource\cr
#'  \link[=apigatewayv2_reset_authorizers_cache]{reset_authorizers_cache} \tab Resets all authorizer cache entries on a stage\cr
#'  \link[=apigatewayv2_tag_resource]{tag_resource} \tab Creates a new Tag resource to represent a tag\cr
#'  \link[=apigatewayv2_untag_resource]{untag_resource} \tab Deletes a Tag\cr
#'  \link[=apigatewayv2_update_api]{update_api} \tab Updates an Api resource\cr
#'  \link[=apigatewayv2_update_api_mapping]{update_api_mapping} \tab The API mapping\cr
#'  \link[=apigatewayv2_update_authorizer]{update_authorizer} \tab Updates an Authorizer\cr
#'  \link[=apigatewayv2_update_deployment]{update_deployment} \tab Updates a Deployment\cr
#'  \link[=apigatewayv2_update_domain_name]{update_domain_name} \tab Updates a domain name\cr
#'  \link[=apigatewayv2_update_integration]{update_integration} \tab Updates an Integration\cr
#'  \link[=apigatewayv2_update_integration_response]{update_integration_response} \tab Updates an IntegrationResponses\cr
#'  \link[=apigatewayv2_update_model]{update_model} \tab Updates a Model\cr
#'  \link[=apigatewayv2_update_route]{update_route} \tab Updates a Route\cr
#'  \link[=apigatewayv2_update_route_response]{update_route_response} \tab Updates a RouteResponse\cr
#'  \link[=apigatewayv2_update_stage]{update_stage} \tab Updates a Stage\cr
#'  \link[=apigatewayv2_update_vpc_link]{update_vpc_link} \tab Updates a VPC link
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname apigatewayv2
#' @export
apigatewayv2 <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .apigatewayv2$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.apigatewayv2 <- list()

.apigatewayv2$operations <- list()

.apigatewayv2$metadata <- list(
  service_name = "apigatewayv2",
  endpoints = list("^(us|eu|ap|sa|ca|me|af|il|mx)\\-\\w+\\-\\d+$" = list(endpoint = "apigateway.{region}.amazonaws.com", global = FALSE), "^cn\\-\\w+\\-\\d+$" = list(endpoint = "apigateway.{region}.amazonaws.com.cn", global = FALSE), "^us\\-gov\\-\\w+\\-\\d+$" = list(endpoint = "apigateway.{region}.amazonaws.com", global = FALSE), "^us\\-iso\\-\\w+\\-\\d+$" = list(endpoint = "apigateway.{region}.c2s.ic.gov", global = FALSE), "^us\\-isob\\-\\w+\\-\\d+$" = list(endpoint = "apigateway.{region}.sc2s.sgov.gov", global = FALSE), "^eu\\-isoe\\-\\w+\\-\\d+$" = list(endpoint = "apigateway.{region}.cloud.adc-e.uk", global = FALSE), "^us\\-isof\\-\\w+\\-\\d+$" = list(endpoint = "apigateway.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "ApiGatewayV2",
  api_version = "2018-11-29",
  signing_name = "apigateway",
  json_version = "1.1",
  target_prefix = ""
)

.apigatewayv2$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.apigatewayv2$metadata, handlers, config, op)
}
