% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_training_plans}
\alias{sagemaker_list_training_plans}
\title{Retrieves a list of training plans for the current account}
\usage{
sagemaker_list_training_plans(
  NextToken = NULL,
  MaxResults = NULL,
  StartTimeAfter = NULL,
  StartTimeBefore = NULL,
  SortBy = NULL,
  SortOrder = NULL,
  Filters = NULL
)
}
\arguments{
\item{NextToken}{A token to continue pagination if more results are available.}

\item{MaxResults}{The maximum number of results to return in the response.}

\item{StartTimeAfter}{Filter to list only training plans with an actual start time after this
date.}

\item{StartTimeBefore}{Filter to list only training plans with an actual start time before this
date.}

\item{SortBy}{The training plan field to sort the results by (e.g., StartTime,
Status).}

\item{SortOrder}{The order to sort the results (Ascending or Descending).}

\item{Filters}{Additional filters to apply to the list of training plans.}
}
\description{
Retrieves a list of training plans for the current account.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_list_training_plans/} for full documentation.
}
\keyword{internal}
