% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_processing_job}
\alias{sagemaker_create_processing_job}
\title{Creates a processing job}
\usage{
sagemaker_create_processing_job(
  ProcessingInputs = NULL,
  ProcessingOutputConfig = NULL,
  ProcessingJobName,
  ProcessingResources,
  StoppingCondition = NULL,
  AppSpecification,
  Environment = NULL,
  NetworkConfig = NULL,
  RoleArn,
  Tags = NULL,
  ExperimentConfig = NULL
)
}
\arguments{
\item{ProcessingInputs}{An array of inputs configuring the data to download into the processing
container.}

\item{ProcessingOutputConfig}{Output configuration for the processing job.}

\item{ProcessingJobName}{[required] The name of the processing job. The name must be unique within an Amazon
Web Services Region in the Amazon Web Services account.}

\item{ProcessingResources}{[required] Identifies the resources, ML compute instances, and ML storage volumes
to deploy for a processing job. In distributed training, you specify
more than one instance.}

\item{StoppingCondition}{The time limit for how long the processing job is allowed to run.}

\item{AppSpecification}{[required] Configures the processing job to run a specified Docker container image.}

\item{Environment}{The environment variables to set in the Docker container. Up to 100 key
and values entries in the map are supported.}

\item{NetworkConfig}{Networking options for a processing job, such as whether to allow
inbound and outbound network calls to and from processing containers,
and the VPC subnets and security groups to use for VPC-enabled
processing jobs.}

\item{RoleArn}{[required] The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can
assume to perform tasks on your behalf.}

\item{Tags}{(Optional) An array of key-value pairs. For more information, see \href{https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL}{Using Cost Allocation Tags}
in the \emph{Amazon Web Services Billing and Cost Management User Guide}.}

\item{ExperimentConfig}{}
}
\description{
Creates a processing job.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_create_processing_job/} for full documentation.
}
\keyword{internal}
