% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frauddetector_operations.R
\name{frauddetector_create_batch_prediction_job}
\alias{frauddetector_create_batch_prediction_job}
\title{Creates a batch prediction job}
\usage{
frauddetector_create_batch_prediction_job(
  jobId,
  inputPath,
  outputPath,
  eventTypeName,
  detectorName,
  detectorVersion = NULL,
  iamRoleArn,
  tags = NULL
)
}
\arguments{
\item{jobId}{[required] The ID of the batch prediction job.}

\item{inputPath}{[required] The Amazon S3 location of your training file.}

\item{outputPath}{[required] The Amazon S3 location of your output file.}

\item{eventTypeName}{[required] The name of the event type.}

\item{detectorName}{[required] The name of the detector.}

\item{detectorVersion}{The detector version.}

\item{iamRoleArn}{[required] The ARN of the IAM role to use for this job request.

The IAM Role must have read permissions to your input S3 bucket and
write permissions to your output S3 bucket. For more information about
bucket permissions, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/example-policies-s3.html}{User policy examples}
in the \emph{Amazon S3 User Guide}.}

\item{tags}{A collection of key and value pairs.}
}
\description{
Creates a batch prediction job.

See \url{https://www.paws-r-sdk.com/docs/frauddetector_create_batch_prediction_job/} for full documentation.
}
\keyword{internal}
