% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecastservice_operations.R
\name{forecastservice_create_what_if_forecast_export}
\alias{forecastservice_create_what_if_forecast_export}
\title{Exports a forecast created by the CreateWhatIfForecast operation to your
Amazon Simple Storage Service (Amazon S3) bucket}
\usage{
forecastservice_create_what_if_forecast_export(
  WhatIfForecastExportName,
  WhatIfForecastArns,
  Destination,
  Tags = NULL,
  Format = NULL
)
}
\arguments{
\item{WhatIfForecastExportName}{[required] The name of the what-if forecast to export.}

\item{WhatIfForecastArns}{[required] The list of what-if forecast Amazon Resource Names (ARNs) to export.}

\item{Destination}{[required] The location where you want to save the forecast and an Identity and
Access Management (IAM) role that Amazon Forecast can assume to access
the location. The forecast must be exported to an Amazon S3 bucket.

If encryption is used, \code{Destination} must include an Key Management
Service (KMS) key. The IAM role must allow Amazon Forecast permission to
access the key.}

\item{Tags}{A list of
\href{https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html}{tags}
to apply to the what if forecast.}

\item{Format}{The format of the exported data, CSV or PARQUET.}
}
\description{
Exports a forecast created by the \code{\link[=forecastservice_create_what_if_forecast]{create_what_if_forecast}} operation to your Amazon Simple Storage Service (Amazon S3) bucket. The forecast file name will match the following conventions:

See \url{https://www.paws-r-sdk.com/docs/forecastservice_create_what_if_forecast_export/} for full documentation.
}
\keyword{internal}
