% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasource.R
\name{pathling_read_ndjson}
\alias{pathling_read_ndjson}
\title{Create a data source from NDJSON}
\usage{
pathling_read_ndjson(pc, path, extension = "ndjson", file_name_mapper = NULL)
}
\arguments{
\item{pc}{The PathlingContext object.}

\item{path}{The URI of the directory containing the NDJSON files.}

\item{extension}{The file extension to use when searching for files. Defaults to "ndjson".}

\item{file_name_mapper}{An optional function that maps a filename to the set of resource types
that it contains. Currently not implemented.}
}
\value{
A DataSource object that can be used to run queries against the data.
}
\description{
Creates a data source from a directory containing NDJSON files. The files must be named with the 
resource type code and must have the ".ndjson" extension, e.g. "Patient.ndjson" or 
"Observation.ndjson".
}
\examples{
\dontrun{
data_source <- pc \%>\% pathling_read_ndjson(pathling_examples('ndjson'))
data_source \%>\% ds_read('Patient') \%>\% sparklyr::sdf_nrow()
}
}
\seealso{
\href{https://pathling.csiro.au/docs/libraries/io#ndjson}{Pathling documentation - Reading NDJSON}

Other data source functions: 
\code{\link{pathling_read_bulk}()},
\code{\link{pathling_read_bundles}()},
\code{\link{pathling_read_datasets}()},
\code{\link{pathling_read_delta}()},
\code{\link{pathling_read_parquet}()},
\code{\link{pathling_read_tables}()}
}
\concept{data source functions}
