% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/y_constraint.R
\docType{data}
\name{y_constraint}
\alias{y_constraint}
\title{Fixes particles to a vertical position}
\description{
This constraint simply prevents particles from moving in the y direction. For
particles where the constraint evaluates to \code{NA} this constraint is ignored.
If the constraint is enforced the velocity in the y direction will be set to
\code{0}.
}
\section{Training parameters}{

The following parameters defines the training of the constraint and can be
passed along a call to \code{\link[=impose]{impose()}}
\itemize{
\item \code{y} : The position on the y-axis to fix to. (\emph{tidy eval})
\item \code{ymin} : The lowest permissible y-value. If \code{NULL} then \code{y} will be used. (\emph{tidy eval})
\item \code{ymax} : The highest permissible y-value. If \code{NULL} then \code{y} will be used. (\emph{tidy eval})
}
}

\seealso{
Other constraints: 
\code{\link{dominator_constraint}},
\code{\link{infinity_constraint}},
\code{\link{path_constraint}},
\code{\link{polygon_constraint}},
\code{\link{velocity_constraint}},
\code{\link{x_constraint}}
}
\concept{constraints}
\keyword{datasets}
