% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pandoc-run.R
\name{pandoc_version}
\alias{pandoc_version}
\title{Get Pandoc version}
\usage{
pandoc_version(version = "default")
}
\arguments{
\item{version}{Version to use. Default will be the \code{"default"} version. Other possible value are
\itemize{
\item A version number e.g \code{"2.14.1"}
\item The nightly version called \code{"nightly"}
\item The latest installed version with \code{"latest"}
\item Pandoc binary shipped with RStudio IDE with \code{"rstudio"}
\item Pandoc binary found in PATH with \code{"system"}
}}
}
\value{
The version number for \code{pandoc} binary as a \code{\link[base:numeric_version]{base::numeric_version()}} object.
}
\description{
This is calling \code{pandoc --version} to retrieve the version of Pandoc used. A
special treatment is done for \emph{nightly} version as Pandoc project does not
use a development version scheme between released versions. This function
will add a \code{.9999} suffix to the version reported by Pandoc.
}
\examples{
\dontshow{if (pandoc::pandoc_available()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pandoc::pandoc_version()
\dontshow{\}) # examplesIf}
\dontshow{if (!is.null(pandoc::pandoc_system_bin()) && pandoc_system_version() > "1.18") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pandoc::pandoc_version(version = "system")
\dontshow{\}) # examplesIf}
}
