% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pandoc-install.R
\name{pandoc_install}
\alias{pandoc_install}
\alias{pandoc_update}
\alias{pandoc_install_nightly}
\title{Install a pandoc binary for Github release page}
\usage{
pandoc_install(version = "latest", force = FALSE)

pandoc_update()

pandoc_install_nightly(n_last = 1L)
}
\arguments{
\item{version}{This can be either:
\itemize{
\item \code{"latest"} for the latest release
\item A version number (e.g \code{"2.11.4"}) for a specific version
\item \code{"nightly"} for the last pandoc development built daily
}}

\item{force}{To set to \code{TRUE} to force a re-installation}

\item{n_last}{Set to \code{n} as integer to install the n-th from last nightly
build. Default is last available build (1L)}
}
\value{
Invisibly, the path where the binary is installed otherwise. \code{NULL} if already
installed.
}
\description{
Binary releases of Pandoc are available on its release page. By default, this
function will install the latest available version.
\code{pandoc_install_nightly()} is a wrapper for \code{pandoc_install("nightly")}.
\code{pandoc_update()} is an alias for \code{pandoc_install()} default behavior.
}
\details{
Pandoc versions are installed in user data directories with one folder per
version. See \code{\link[=pandoc_locate]{pandoc_locate()}}.

Only one nightly version is available at a time as there should be no need to
switch between them. The latest nightly will be installed over the current
one if any. Installing nightly version is useful for example to test a bug
against the very last available built version.
}
\examples{
\dontshow{if (rlang::is_interactive() && !pandoc::pandoc_is_installed("latest")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Install the latest pandoc version
pandoc_install() # or pandoc_update()
pandoc_uninstall("latest")
\dontshow{\}) # examplesIf}
\dontshow{if (rlang::is_interactive() && !pandoc::pandoc_is_installed("2.11.4")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Install a specific pandoc version
pandoc_install("2.11.4")
pandoc_uninstall("2.11.4")
\dontshow{\}) # examplesIf}
\dontshow{if (rlang::is_interactive() && !pandoc::pandoc_is_installed("nightly")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Install last nightly build of pandoc
pandoc_install_nightly()
pandoc_uninstall("nightly")
\dontshow{\}) # examplesIf}
}
