% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{run_granger_test}
\alias{run_granger_test}
\title{Use Granger-causality Test to get gene-gene regulatory relationship}
\usage{
run_granger_test(
  data,
  ptime,
  slide_window_size = 20,
  slide_step_size = 10,
  pvalue_cutoff = 0.01,
  order = 1,
  ...
)
}
\arguments{
\item{data}{gene expression matrix (Gene * Cells)}

\item{ptime}{pseudotime matched with the column cells of the gene expression matrix}

\item{slide_window_size}{sliding window size}

\item{slide_step_size}{sliding window step size}

\item{pvalue_cutoff}{cutoff for the pvalue from transfer entropy test}

\item{order}{integer specifying the order of lags to include in the auxiliary regression}

\item{...}{other parameters for grangertest function in lmtest}
}
\value{
adjacency data frame
}
\description{
Based on single-cell gene expression matrix and pseudotime, calculate Granger-causality Test
based gene-gene regulatory relationship
}
\examples{

example_data <- pGRNDB
expression_matrix <- example_data[["expression"]]
pseudotime_list <- example_data[["ptime"]]$PseudoTime
gt_adj_df <- run_granger_test(expression_matrix, pseudotime_list)

}
