% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elements.R
\name{svg_text}
\alias{svg_text}
\title{Addition of a \code{text} element}
\usage{
svg_text(
  svg,
  x,
  y,
  text,
  fill = NULL,
  opacity = NULL,
  path = NULL,
  attrs = list(),
  anims = list(),
  filters = list(),
  id = NULL
)
}
\arguments{
\item{svg}{The \code{svg} object that is created using the \code{\link[=SVG]{SVG()}} function.}

\item{x, y}{The \code{x} and \code{y} positions of the upper left of the text to be
drawn. The \code{x} and \code{y} values are relative to upper left of the SVG drawing
area itself.}

\item{text}{A character vector that contains the text to be rendered.}

\item{fill}{The color of the text.}

\item{opacity}{The opacity of the element. Must be a value in the
range of \code{0} to \code{1}.}

\item{path}{A single-length character vector that holds the formatted path
string.}

\item{attrs}{A presentation attribute list. The helper function
\code{\link[=svg_attrs_pres]{svg_attrs_pres()}} can help us easily generate this named list object. For the
most part, the list's names are the presentation attribute names and the
corresponding values are the matching attribute values.}

\item{anims}{An animation directive list for the element. This should be
structured using the \code{\link[=anims]{anims()}} function.}

\item{filters}{A filter directive list for the element. This is easily
created by using a list of \verb{filter_*()} functions (e.g.,
\code{list(filter_gaussian_blur(2), filter_drop_shadow(2, 2))}).}

\item{id}{An optional ID value to give to the built tag. This is useful for
modifying this element in a later function call or for interacting with
CSS.}
}
\value{
An \code{svg} object.
}
\description{
The \code{svg_text()} function adds text to an \code{svg} object. As with many of the
functions that create shape elements (such as \code{\link[=svg_rect]{svg_rect()}}), the starting
position is defined by \code{x} and \code{y} values. All point positions are in units
of \code{px}.
}
