% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elements.R
\name{svg_path}
\alias{svg_path}
\title{Addition of an \code{path} element}
\usage{
svg_path(
  svg,
  path,
  stroke = NULL,
  stroke_width = NULL,
  fill = NULL,
  opacity = NULL,
  attrs = list(),
  anims = list(),
  filters = list(),
  id = NULL
)
}
\arguments{
\item{svg}{The \code{svg} object that is created using the \code{\link[=SVG]{SVG()}} function.}

\item{path}{A single-length character vector that holds the formatted path
string.}

\item{stroke}{The color of the stroke applied to the element (i.e., the
outline).}

\item{stroke_width}{The width of the stroke in units of pixels.}

\item{fill}{The fill color of the element.}

\item{opacity}{The opacity of the element. Must be a value in the
range of \code{0} to \code{1}.}

\item{attrs}{A presentation attribute list. The helper function
\code{\link[=svg_attrs_pres]{svg_attrs_pres()}} can help us easily generate this named list object. For the
most part, the list's names are the presentation attribute names and the
corresponding values are the matching attribute values.}

\item{anims}{An animation directive list for the element. This should be
structured using the \code{\link[=anims]{anims()}} function.}

\item{filters}{A filter directive list for the element. This is easily
created by using a list of \verb{filter_*()} functions (e.g.,
\code{list(filter_gaussian_blur(2), filter_drop_shadow(2, 2))}).}

\item{id}{An optional ID value to give to the built tag. This is useful for
modifying this element in a later function call or for interacting with
CSS.}
}
\value{
An \code{svg} object.
}
\description{
The \code{svg_path()} function adds a path to an \code{svg} object. A path can
potentially be quite complex (with an interplay of line and curve commands),
so, a hand-encoded \code{path} string is not often done by hand. For this reason,
the \code{path} argument accepts only a formatted string that complies with the
input requirements for the \code{d} attribute of the SVG \verb{<path>} tag. All point
positions are in units of \code{px}.
}
\examples{
if (interactive()) {

# Create an SVG with a single
# path element
svg <-
  SVG(width = 300, height = 300) \%>\%
    svg_path(
      path = "M 50 160 q 100 -300 200 0",
      stroke = "magenta",
      stroke_width = 5,
      fill = "lightblue"
    )
}

}
