% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_drop_shadow}
\alias{filter_drop_shadow}
\title{Filter: add a drop shadow to an element}
\usage{
filter_drop_shadow(dx = 0.2, dy = 0.2, stdev = 1, color = "black", opacity = 1)
}
\arguments{
\item{dx, dy}{The offset of the drop shadow compared to the position of the
input image or shape.}

\item{stdev}{The number of standard deviations for the blur effect.}

\item{color}{The color of the drop shadow.}

\item{opacity}{The opacity of the drop shadow. We can use a real number from
\code{0} to \code{1} or a value in percentage units.}
}
\value{
An \code{svg} object.
}
\description{
With the \code{filter_drop_shadow()} drop shadow appears beneath the input image
or shape and its offset is controlled by \code{dx} and \code{dy}. The blurring of the
drop shadow is set by the \code{stdev} value.
}
\examples{
if (interactive()) {

# Apply a drop shadow filter on a
# text element (orange in color,
# and semi-opaque)
SVG(width = 250, height = 100) \%>\%
  svg_filter(
    id = "shadow",
    filters = list(
      filter_drop_shadow(
        dx = 1, dy = 2,
        color = "orange",
        opacity = 0.5
      )
    )
  ) \%>\%
  svg_text(
    x = 10, y = 40,
    text = "Shadowed",
    attrs = svg_attrs_pres(
      font_size = "2em",
      fill = "#555555",
      font_weight = "bolder",
      filter = "shadow"
    )
  )
}

}
