% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anim_opacity.R
\name{anim_opacity}
\alias{anim_opacity}
\title{Animate an element through an opacity change}
\usage{
anim_opacity(opacity = NULL, easing_fn = NULL, initial = FALSE)
}
\arguments{
\item{opacity}{The opacity value of the element at the keyframe time (given
as the LHS value in the \code{\link[=anims]{anims()}} call).}

\item{easing_fn}{The timing or easing function to use for the animation. If
not provided, the \code{\link[=linear]{linear()}} timing function will be used (which is doesn't
use any easing in the animation, just a linear movement). The other timing
and easing functions are: \code{\link[=step_start]{step_start()}}, \code{\link[=step_end]{step_end()}}, \code{\link[=ease_in]{ease_in()}},
\code{\link[=ease_out]{ease_out()}}, and \code{\link[=ease_in_out]{ease_in_out()}}.}

\item{initial}{Should this opacity value be the initial opacity value of
the element? If so, use \code{TRUE} and any value provided to \code{opacity} will be
disregarded.}
}
\value{
An \code{anim_opacity} object, which is to be used as part of an \code{\link[=anims]{anims()}}
call.
}
\description{
Within an \code{\link[=anims]{anims()}} call, itself passed to any \code{anims} argument, the
\code{anim_opacity()} function can be used to express an animation where the
target element undergoes a change in opacity with time.
}
\examples{
if (interactive()) {

# Basic animation of an element's
# opacity value (moving to a new
# `opacity` value of `0`)
SVG(width = 300, height = 300) \%>\%
  svg_rect(
    x = 50, y = 50,
    width = 50, height = 50,
    attrs = svg_attrs_pres(
      stroke = "magenta",
      fill = "lightblue"
    ),
    anims = anims(
      2.0 ~ anim_opacity(opacity = 0)
    )
  )
}

}
