% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elements.R
\name{svg_polygon}
\alias{svg_polygon}
\title{Addition of an \code{polygon} element}
\usage{
svg_polygon(
  svg,
  points,
  stroke = NULL,
  stroke_width = NULL,
  fill = NULL,
  opacity = NULL,
  attrs = list(),
  anims = list(),
  filters = list(),
  id = NULL
)
}
\arguments{
\item{svg}{The \code{svg} object that is created using the \code{\link[=SVG]{SVG()}} function.}

\item{points}{A numeric vector of points (with alternating values for \code{x} and
\code{y} positions) that define the polygon. This can also be a single-length
character vector that holds the formatted points string (space-separated
\code{x} and \code{y} values, and comma-separated points).}

\item{stroke}{The color of the stroke applied to the element (i.e., the
outline).}

\item{stroke_width}{The width of the stroke in units of pixels.}

\item{fill}{The fill color of the element.}

\item{opacity}{The opacity of the element. Must be a value in the
range of \code{0} to \code{1}.}

\item{attrs}{A presentation attribute list. The helper function
\code{\link[=svg_attrs_pres]{svg_attrs_pres()}} can help us easily generate this named list object. For the
most part, the list's names are the presentation attribute names and the
corresponding values are the matching attribute values.}

\item{anims}{An animation directive list for the element. This should be
structured using the \code{\link[=anims]{anims()}} function.}

\item{filters}{A filter directive list for the element. This is easily
created by using a list of \verb{filter_*()} functions (e.g.,
\code{list(filter_gaussian_blur(2), filter_drop_shadow(2, 2))}).}

\item{id}{An optional ID value to give to the built tag. This is useful for
modifying this element in a later function call or for interacting with
CSS.}
}
\value{
An \code{svg} object.
}
\description{
The \code{svg_polygon()} function adds a polygon to an \code{svg} object. In the
context of an SVG shape a polygon is similar to a polyline (defined by a
series of points) except that the path will be automatically closed (i.e.,
last point connects to the first point). Like a polyline, a polygon is drawn
by connecting a series of points with straight lines. The points can be
provided as a vector that's exactly divisible by two, or, as a formatted
string that adheres to the specification of the \code{points} attribute of the SVG
\verb{<polygon>} tag. All point positions are in units of \code{px}.
}
\examples{
if (interactive()) {

# Create an SVG with a single
# polygon element
svg <-
  SVG(width = 300, height = 300) \%>\%
    svg_polygon(
      points = "100,10 40,198 190,78 10,78 160,198",
      stroke = "orange",
      stroke_width = 4,
      fill = "yellow"
    )
}

}
