% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_gaussian_blur}
\alias{filter_gaussian_blur}
\title{Filter: add a gaussian blur to an element}
\usage{
filter_gaussian_blur(stdev = 1, what = "source")
}
\arguments{
\item{stdev}{The number of standard deviations for the blur effect.}

\item{what}{What exactly should be blurred? By default, it is the \code{"source"}
image.}
}
\value{
An \code{svg} object.
}
\description{
A gaussian blur effectively blurs an input image or shape by the amount
specified in \code{stdev}. The standard deviation of \code{stdev} is in direct
reference to the gaussian distribution that governs the extent of blurring.
}
\examples{
if (interactive()) {

# Add a green ellipse to an SVG and
# then apply the `filter_gaussian_blur()`
# filter to blur the edges
SVG(width = 200, height = 100) \%>\%
  svg_filter(
    id = "blur",
    filters = list(
      filter_gaussian_blur(stdev = 2)
    )
  ) \%>\%
  svg_ellipse(
    x = 40, y = 40,
    width = 50, height = 30,
    attrs = svg_attrs_pres(
      fill = "green",
      filter = "blur"
    )
  )
}

}
