% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argo.R
\name{summary,argo-method}
\alias{summary,argo-method}
\alias{summary.argo}
\title{Summarize an argo Object}
\usage{
\S4method{summary}{argo}(object, ...)
}
\arguments{
\item{object}{an object of class \code{"argo"}, usually, a result of a call to \code{\link[=read.argo]{read.argo()}}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A matrix containing statistics of the elements of the \code{data} slot.
}
\description{
Summarizes some of the data in an \code{argo} object.
}
\details{
Pertinent summary information is presented.
}
\examples{
library(oce)
data(argo)
summary(argo)

}
\seealso{
Other things related to argo data: 
\code{\link{[[,argo-method}},
\code{\link{[[<-,argo-method}},
\code{\link{argo}},
\code{\link{argo-class}},
\code{\link{argoGrid}()},
\code{\link{argoNames2oceNames}()},
\code{\link{as.argo}()},
\code{\link{handleFlags,argo-method}},
\code{\link{plot,argo-method}},
\code{\link{read.argo}()},
\code{\link{read.argo.copernicus}()},
\code{\link{subset,argo-method}}
}
\author{
Dan Kelley
}
\concept{things related to argo data}
