% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adp.R
\name{summary,adp-method}
\alias{summary,adp-method}
\alias{summary.adp}
\alias{summary,adp,missing-method}
\title{Summarize an adp Object}
\usage{
\S4method{summary}{adp}(object, ...)
}
\arguments{
\item{object}{an object of class \code{"adp"}, usually, a result of a call
to \code{\link[=read.oce]{read.oce()}}, \code{\link[=read.adp.rdi]{read.adp.rdi()}}, or
\code{\link[=read.adp.nortek]{read.adp.nortek()}}.}

\item{\dots}{further arguments passed to or from other methods.}
}
\value{
A matrix containing statistics of the elements of the \code{data}
slot.
}
\description{
Summarize data in an \code{adp} object.
}
\details{
Pertinent summary information is presented.
}
\seealso{
Other things related to adp data: 
\code{\link{[[,adp-method}},
\code{\link{[[<-,adp-method}},
\code{\link{ad2cpCodeToName}()},
\code{\link{ad2cpHeaderValue}()},
\code{\link{adp}},
\code{\link{adp-class}},
\code{\link{adpAd2cpFileTrim}()},
\code{\link{adpConvertRawToNumeric}()},
\code{\link{adpEnsembleAverage}()},
\code{\link{adpFlagPastBoundary}()},
\code{\link{adpRdiFileTrim}()},
\code{\link{adp_rdi.000}},
\code{\link{applyMagneticDeclination,adp-method}},
\code{\link{as.adp}()},
\code{\link{beamName}()},
\code{\link{beamToXyz}()},
\code{\link{beamToXyzAdp}()},
\code{\link{beamToXyzAdpAD2CP}()},
\code{\link{beamToXyzAdv}()},
\code{\link{beamUnspreadAdp}()},
\code{\link{binmapAdp}()},
\code{\link{enuToOther}()},
\code{\link{enuToOtherAdp}()},
\code{\link{handleFlags,adp-method}},
\code{\link{is.ad2cp}()},
\code{\link{plot,adp-method}},
\code{\link{read.adp}()},
\code{\link{read.adp.ad2cp}()},
\code{\link{read.adp.nortek}()},
\code{\link{read.adp.rdi}()},
\code{\link{read.adp.sontek}()},
\code{\link{read.adp.sontek.serial}()},
\code{\link{read.aquadopp}()},
\code{\link{read.aquadoppHR}()},
\code{\link{read.aquadoppProfiler}()},
\code{\link{rotateAboutZ}()},
\code{\link{setFlags,adp-method}},
\code{\link{subset,adp-method}},
\code{\link{subtractBottomVelocity}()},
\code{\link{toEnu}()},
\code{\link{toEnuAdp}()},
\code{\link{velocityStatistics}()},
\code{\link{xyzToEnu}()},
\code{\link{xyzToEnuAdp}()},
\code{\link{xyzToEnuAdpAD2CP}()}
}
\author{
Dan Kelley
}
\concept{things related to adp data}
