% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sw.R
\name{swSpiciness2}
\alias{swSpiciness2}
\title{Spiciness in gsw System, Referenced to 2000 dbar Pressure}
\usage{
swSpiciness2(salinity, temperature, pressure, longitude, latitude)
}
\arguments{
\item{salinity}{either salinity, or an oce object that contains salinity,
temperature, pressure, longitude and latitude.}

\item{temperature}{in-situ temperature (ignored if \code{salinity} is an oce object)}

\item{pressure}{seawater pressure in dbar (ignored if \code{salinity} is an oce object)}

\item{longitude, latitude}{observation location (ignored if \code{salinity} is an oce object).}
}
\value{
seawater spiciness with respect to a reference pressure of 2000 dbar,
as defined in the \code{gsw} (TEOS-10)
system (McDougall et al, 2011) and computed with \code{\link[gsw:gsw_spiciness2]{gsw::gsw_spiciness2()}}.
}
\description{
Computes seawater spiciness using \code{\link[gsw:gsw_spiciness2]{gsw::gsw_spiciness2()}} for
a reference pressure of 2000 dbar.
}
\references{
McDougall, T.J. and P.M. Barker, 2011: Getting started with TEOS-10 and
the Gibbs Seawater (GSW) Oceanographic Toolbox, 28pp., SCOR/IAPSO WG127,
ISBN 978-0-646-55621-5.
}
\seealso{
Other functions that calculate seawater spiciness: 
\code{\link{swSpice}()},
\code{\link{swSpiciness0}()},
\code{\link{swSpiciness1}()}

Other functions that calculate seawater properties: 
\code{\link{T68fromT90}()},
\code{\link{T90fromT48}()},
\code{\link{T90fromT68}()},
\code{\link{computableWaterProperties}()},
\code{\link{locationForGsw}()},
\code{\link{swAbsoluteSalinity}()},
\code{\link{swAlpha}()},
\code{\link{swAlphaOverBeta}()},
\code{\link{swBeta}()},
\code{\link{swCSTp}()},
\code{\link{swConservativeTemperature}()},
\code{\link{swDepth}()},
\code{\link{swDynamicHeight}()},
\code{\link{swLapseRate}()},
\code{\link{swN2}()},
\code{\link{swPressure}()},
\code{\link{swRho}()},
\code{\link{swRrho}()},
\code{\link{swSCTp}()},
\code{\link{swSR}()},
\code{\link{swSTrho}()},
\code{\link{swSigma}()},
\code{\link{swSigma0}()},
\code{\link{swSigma1}()},
\code{\link{swSigma2}()},
\code{\link{swSigma3}()},
\code{\link{swSigma4}()},
\code{\link{swSigmaT}()},
\code{\link{swSigmaTheta}()},
\code{\link{swSoundAbsorption}()},
\code{\link{swSoundSpeed}()},
\code{\link{swSpecificHeat}()},
\code{\link{swSpice}()},
\code{\link{swSpiciness0}()},
\code{\link{swSpiciness1}()},
\code{\link{swSstar}()},
\code{\link{swTFreeze}()},
\code{\link{swTSrho}()},
\code{\link{swThermalConductivity}()},
\code{\link{swTheta}()},
\code{\link{swViscosity}()},
\code{\link{swZ}()}
}
\author{
Dan Kelley
}
\concept{functions that calculate seawater properties}
\concept{functions that calculate seawater spiciness}
