% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xbt.R
\name{read.xbt.edf}
\alias{read.xbt.edf}
\title{Read an xbt File in Sippican Format}
\usage{
read.xbt.edf(
  file,
  longitude = NA,
  latitude = NA,
  encoding = "latin1",
  debug = getOption("oceDebug"),
  processingLog
)
}
\arguments{
\item{file}{a connection or a character string giving the name of the file to
load.}

\item{longitude}{optional signed number indicating the longitude in degrees
East.}

\item{latitude}{optional signed number indicating the latitude in degrees North.}

\item{encoding}{a character value that indicates the encoding to be used for
this data file, if it is textual.  The default value for most functions is
\code{"latin1"}, which seems to be suitable for files containing text written in
English and French.}

\item{debug}{a flag that turns on debugging.  The value indicates the depth
within the call stack to which debugging applies.}

\item{processingLog}{if provided, the action item to be stored in the log.  This
parameter is typically only provided for internal calls; the default that it
provides is better for normal calls by a user.}
}
\value{
An \linkS4class{xbt} object.
}
\description{
The function was written by inspection of a particular file, and might
be wrong for other files; see \dQuote{Details} for a note on character
translation.
}
\details{
The header is converted to ASCII format prior to storage in
the \code{metadata} slot, so that e.g. a degree sign in the original file will
become a \verb{?} character in the \code{header}.  This is to prevent problems
with submission of \code{oce} to the CRAN system, which produces NOTEs
about UTF-8 strings in data (on some build machines, evidently depending
on the locale on those machines).  This character substitution
is at odds with the \code{oce} philosophy of leaving data intact, so
it will be reverted, if CRAN policy changes or if the developers
can find a way to otherwise silence the NOTE.
}
\examples{
library(oce)
xbt <- read.oce(system.file("extdata", "xbt.edf", package = "oce"))
summary(xbt)
plot(xbt)

}
\author{
Dan Kelley
}
