% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amsr.R
\name{plot,amsr-method}
\alias{plot,amsr-method}
\alias{plot.amsr}
\title{Plot an amsr Object}
\usage{
\S4method{plot}{amsr}(
  x,
  y,
  asp = NULL,
  breaks,
  col,
  colormap,
  zlim,
  zlab,
  missingColor,
  debug = getOption("oceDebug"),
  ...
)
}
\arguments{
\item{x}{an \linkS4class{amsr} object.}

\item{y}{character value indicating the name of the band to plot;
if not provided, \code{SST} (or a variant thereof) is used; see the
documentation for the \linkS4class{amsr} class for a list of bands.}

\item{asp}{optional numerical value giving the aspect ratio for plot.  The
default value, \code{NULL}, means to use an aspect ratio of 1 for world views,
and a value computed from \code{ylim}, if the latter is specified in the
\code{...} argument.}

\item{breaks}{optional numeric vector of the z values for breaks in
the color scheme. If \code{colormap} is provided, it takes precedence
over \code{breaks} and \code{col}.}

\item{col}{optional argument, either a vector of colors
corresponding to the breaks, of length 1 less than the number of
breaks, or a function specifying colors. If neither \code{col} or
\code{colormap} is provided, then \code{col} defaults to
\code{\link[=oceColorsTemperature]{oceColorsTemperature()}}. If \code{colormap} is provided, it takes
precedence over \code{breaks} and \code{col}.}

\item{colormap}{a specification of the colormap to use, as created
with \code{\link[=colormap]{colormap()}}.  If \code{colormap} is NULL, which is the default,
then a colormap is created to cover the range of data values, using
\link{oceColorsTemperature} color scheme. If \code{colormap} is provided, it
takes precedence over \code{breaks} and \code{col}. See \dQuote{Examples} for
an example of using the "turbo" color scheme.}

\item{zlim}{optional numeric vector of length 2, giving the limits
of the plotted quantity.  A reasonable default is computed, if this
is not given.}

\item{zlab}{optional character value that is shown in the top-right
margin of the plot. If not given, this defaults to the name of the
plotted variable.}

\item{missingColor}{optional list specifying colors to use for
non-data categories.  If not provided, a default is used.  For type
1, that default is \code{list(land="papayaWhip", none="lightGray", bad="gray", rain="plum", ice="mediumVioletRed")}.  For type 2, it
is \code{list(coast="gray", land="papayaWhip", noObs="lightGray", seaIce="mediumVioletRed")}.  Any colors may be used in place of
these, but the names must match, and all names must be present.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}

\item{...}{extra arguments passed to \code{\link[=imagep]{imagep()}}, e.g. to control
the view with \code{xlim} (for longitude) and \code{ylim} (for latitude).}
}
\description{
Plot an image of a component of an \linkS4class{amsr} object.
}
\details{
In addition to fields named directly in the object, such as \code{SSTDay} and
\code{SSTNight}, it is also possible to plot computed fields, such as \code{SST},
which combines the day and night fields.
}
\examples{
library(oce)
data(coastlineWorld)
data(amsr) # see ?amsr for how to read and composite such objects

# Example 1: plot with default color scheme, oceColorsTemperature()
plot(amsr, "SST")
lines(coastlineWorld[["longitude"]], coastlineWorld[["latitude"]])

# Example 2: 'turbo' color scheme
plot(amsr, "SST", col = oceColorsTurbo)
lines(coastlineWorld[["longitude"]], coastlineWorld[["latitude"]])

}
\seealso{
Other things related to amsr data: 
\code{\link{[[,amsr-method}},
\code{\link{[[<-,amsr-method}},
\code{\link{amsr}},
\code{\link{amsr-class}},
\code{\link{composite,amsr-method}},
\code{\link{download.amsr}()},
\code{\link{read.amsr}()},
\code{\link{subset,amsr-method}},
\code{\link{summary,amsr-method}}

Other functions that plot oce data: 
\code{\link{download.amsr}()},
\code{\link{plot,adp-method}},
\code{\link{plot,adv-method}},
\code{\link{plot,argo-method}},
\code{\link{plot,bremen-method}},
\code{\link{plot,cm-method}},
\code{\link{plot,coastline-method}},
\code{\link{plot,ctd-method}},
\code{\link{plot,gps-method}},
\code{\link{plot,ladp-method}},
\code{\link{plot,landsat-method}},
\code{\link{plot,lisst-method}},
\code{\link{plot,lobo-method}},
\code{\link{plot,met-method}},
\code{\link{plot,odf-method}},
\code{\link{plot,rsk-method}},
\code{\link{plot,satellite-method}},
\code{\link{plot,sealevel-method}},
\code{\link{plot,section-method}},
\code{\link{plot,tidem-method}},
\code{\link{plot,topo-method}},
\code{\link{plot,windrose-method}},
\code{\link{plot,xbt-method}},
\code{\link{plotProfile}()},
\code{\link{plotScan}()},
\code{\link{plotTS}()},
\code{\link{tidem-class}}
}
\author{
Dan Kelley
}
\concept{functions that plot oce data}
\concept{things related to amsr data}
