% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{lonlat2map}
\alias{lonlat2map}
\title{Convert Longitude and Latitude to X and Y}
\usage{
lonlat2map(longitude, latitude, projection = "", debug = getOption("oceDebug"))
}
\arguments{
\item{longitude}{a numeric vector containing decimal longitudes, or a list
containing items named \code{longitude} and \code{latitude}, in which case
the indicated values are used, and next argument is ignored.}

\item{latitude}{a numeric vector containing decimal latitude (ignored if
\code{longitude} is a list, as described above).}

\item{projection}{optional indication of projection.  This must be character
string in the format used by the \CRANpkg{sf} package;
see \code{\link[=mapPlot]{mapPlot()}}.)}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}
}
\value{
A list containing \code{x} and \code{y}.
}
\description{
If a projection is already being used (e.g. as set by \code{\link[=mapPlot]{mapPlot()}})
then only \code{longitude} and \code{latitude} should be given, and the
other arguments will be inferred by \code{lonlat2map}.  This is important
because otherwise, if a new projection is called for, it will ruin any
additions to the existing plot.
}
\examples{
library(oce)
# Cape Split, in the Minas Basin of the Bay of Fundy
cs <- list(longitude = -64.49657, latitude = 45.33462)
xy <- lonlat2map(cs, projection = "+proj=merc")
map2lonlat(xy)

}
\seealso{
\code{mapLongitudeLatitudeXY} is a safer alternative, if a map has
already been drawn with \code{\link[=mapPlot]{mapPlot()}}, because that function cannot
alter an existing projection. \code{\link[=map2lonlat]{map2lonlat()}} is an inverse to
\code{map2lonlat}.

Other functions related to maps: 
\code{\link{formatPosition}()},
\code{\link{lonlat2utm}()},
\code{\link{map2lonlat}()},
\code{\link{mapArrows}()},
\code{\link{mapAxis}()},
\code{\link{mapContour}()},
\code{\link{mapCoordinateSystem}()},
\code{\link{mapDirectionField}()},
\code{\link{mapGrid}()},
\code{\link{mapImage}()},
\code{\link{mapLines}()},
\code{\link{mapLocator}()},
\code{\link{mapLongitudeLatitudeXY}()},
\code{\link{mapPlot}()},
\code{\link{mapPoints}()},
\code{\link{mapPolygon}()},
\code{\link{mapScalebar}()},
\code{\link{mapText}()},
\code{\link{mapTissot}()},
\code{\link{oceCRS}()},
\code{\link{oceProject}()},
\code{\link{shiftLongitude}()},
\code{\link{usrLonLat}()},
\code{\link{utm2lonlat}()}
}
\author{
Dan Kelley
}
\concept{functions related to maps}
