% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\name{defaultFlags}
\alias{defaultFlags}
\title{Suggest a Default Flag Vector for Bad or Suspicious Data}
\usage{
defaultFlags(object)
}
\arguments{
\item{object}{An oce object}
}
\value{
A vector of one or more flag values, or \code{NULL} if \code{object}
\code{metadata} slot lacks a \code{flagScheme} as set by \code{\link[=initializeFlagScheme]{initializeFlagScheme()}},
or if it has a scheme that is not in the list provide in \dQuote{Description}.
}
\description{
\code{defaultFlags} tries to suggest a reasonable default \code{flag} scheme
for use by \code{\link[=handleFlags]{handleFlags()}}. It does this by looking for an item
named \code{flagScheme} in the \code{metadata} slot of \code{object}.
If \code{flagScheme} is found, and if the scheme is recognized, then a numeric
vector is returned that indicates bad or questionable data. If
\code{flagScheme$default} exists, then that scheme is returned. However,
if that does not exist, and if \code{flagScheme$name} is recognized,
then a pre-defined (very conservative) scheme is used,
as listed below.
}
\details{
\itemize{
\item for \code{argo}, the default is
\code{c(0,3,4,6,7,9)}, meaning to act upon \code{not_assessed} (0), \code{probably_bad} (3),
\code{bad} (4), \code{not_used_6} (6), \code{not_used_7} (7) and \code{missing} (9).  See Section
3.2.2 of Carval et al. (2019).
\item for \code{BODC}, the default is
\code{c(0,2,3,4,5,6,7,8,9)}, i.e. all flags except \code{good}.
\item for \code{DFO}, the default is
\code{c(0,2,3,4,5,8,9)}, i.e. all flags except \code{appears_correct}.
\item for \verb{WHP bottle}, the default is
\code{c(1,3,4,5,6,7,8,9)}, i.e. all flags except \code{no_problems_noted}.
\item for \verb{WHP ctd}, the default is
\code{c(1,3,4,5,6,7,9)}, i.e. all flags except \code{acceptable}.
}
}
\references{
\itemize{
\item Carval, Thierry, Bob Keeley, Yasushi Takatsuki, Takashi Yoshida, Stephen Loch Loch,
Claudia Schmid, and Roger Goldsmith. Argo User's Manual V3.3. Ifremer, 2019.
\doi{10.13155/29825}
}
}
\seealso{
Other functions relating to data-quality flags: 
\code{\link{handleFlags}()},
\code{\link{handleFlags,adp-method}},
\code{\link{handleFlags,argo-method}},
\code{\link{handleFlags,ctd-method}},
\code{\link{handleFlags,oce-method}},
\code{\link{handleFlags,section-method}},
\code{\link{initializeFlagScheme}()},
\code{\link{initializeFlagScheme,ctd-method}},
\code{\link{initializeFlagScheme,oce-method}},
\code{\link{initializeFlagScheme,section-method}},
\code{\link{initializeFlagSchemeInternal}()},
\code{\link{initializeFlags}()},
\code{\link{initializeFlags,adp-method}},
\code{\link{initializeFlags,oce-method}},
\code{\link{initializeFlagsInternal}()},
\code{\link{setFlags}()},
\code{\link{setFlags,adp-method}},
\code{\link{setFlags,ctd-method}},
\code{\link{setFlags,oce-method}}
}
\concept{functions relating to data-quality flags}
