% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_priors.R
\name{custom_priors}
\alias{custom_priors}
\alias{print.custom_priors}
\title{Customise priors for outbreaker}
\usage{
custom_priors(...)

\method{print}{custom_priors}(x, ...)
}
\arguments{
\item{...}{A list or a series of named, comma-separated functions
implementing priors. Each function must have a single argument, which
corresponds to a 'outbreaker_param' list.}

\item{x}{an \code{outbreaker_config} object as returned by \code{create_config}.}
}
\value{
A named list of custom functions with class \code{custom_priors}. Values
    set to \code{NULL} will be ignored and default functions will be used
    instead.
}
\description{
Priors can be specified in several ways in o2geosocial (see details and
examples). The most flexible way to specify a prior is to provide a prior
function directly. This function must take an argument 'param', which is a
list which contains all the states of the parameters and augmented data. See
the documentation of \link{create_param} for more information.
}
\details{
There are three ways a user can specify priors:\cr

1) Default: this is what happens when the 'config' has default values of
prior parameters.\cr
2) Customized parameters: in this case, the prior functions are the default
ones from the package, but will use custom parameters, specified by the user
through \code{\link{create_config}}.\cr

3) Customized functions: in this case, prior functions themselves are
specified by the user, through the '...' argument of 'custom_priors'. The
requirements is that such functions must have either hard-coded parameters or
enclosed values. They will take a single argument which is a list containing
all model parameters with the class 'outbreaker_param'. ALL PRIORS functions
are expected to return values on a LOG SCALE.\cr

Priors currently used for the model are:
\itemize{

\item \code{pi} (reporting probability): default function is a beta
distribution implemented in \code{cpp_prior_pi}. New prior
functions should use \code{x$pi} to refer to the current value of \code{pi},
assuming their argument is called \code{x}.

\item \code{a} (first spatial parameter (population)): default function is 
a uniform distribution implemented in \code{cpp_prior_a}. 
New prior functions should use \code{x$a} to refer to the current value of \code{a},
assuming their argument is called \code{x}.

\item \code{b} (second spatial parameter (distance)): default function is 
a uniform distribution implemented in \code{cpp_prior_b}.
New prior functions should use \code{x$b} to refer to the current value of \code{b},
assuming their argument is called \code{x}.

}
}
\examples{
## SPECIFYING PRIOR PARAMETERS
## Default values: pi follows a beta distribution (parameters 10, 1), 
## a and b follow a uniform distribution (parameters 0, 5)
default_config <- create_config()
## Use the variables prior_a, prior_b and prior_pi to change the parameters
## of the prior distributions can be 
new_config <- create_config(prior_a = c(0,5), prior_b = c(0,5),
                        prior_pi = c(2, 1))


## SPECIFYING A NEW PRIOR FUNCTION
## Example: flat prior for pi between 0.5 and 1
f <- function(x) {ifelse(x$pi > 0.5, log(2), log(0))}
priors <- custom_priors(pi = f)
## test the new prior distribution
priors$pi(list(pi=1))
priors$pi(list(pi=.6))
priors$pi(list(pi=.2))
priors$pi(list(pi=.49))

}
\author{
Initial version by Thibaut Jombart, rewritten by Alexis Robert (\email{alexis.robert@lshtm.ac.uk})
}
