% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ntfy.R
\name{ntfy_done}
\alias{ntfy_done}
\alias{ntfy_done_with_timing}
\title{Notify on Completion of a Process}
\usage{
ntfy_done(
  x,
  message = paste0("Process completed at ", format(Sys.time())),
  title = "ntfy_done()",
  tags = "white_check_mark",
  topic = ntfy_topic(),
  server = ntfy_server(),
  auth = ntfy_auth(),
  username = ntfy_username(),
  password = ntfy_password(),
  ...
)

ntfy_done_with_timing(
  x,
  message = paste0("Process completed in ", format(time_result), "s"),
  title = "ntfy_done_with_timing()",
  tags = "stopwatch",
  topic = ntfy_topic(),
  server = ntfy_server(),
  auth = ntfy_auth(),
  username = ntfy_username(),
  password = ntfy_password(),
  ...
)
}
\arguments{
\item{x}{a result (ignored)}

\item{message}{text to send as notification}

\item{title}{title of notification. See \url{https://docs.ntfy.sh/publish/#message-title}}

\item{tags}{text tags or emoji shortcodes from \url{https://docs.ntfy.sh/emojis/},
provided as a list}

\item{topic}{subscribed topic to which to send notification}

\item{server}{ntfy server}

\item{auth}{logical indicating if the topic requires password authorization}

\item{username}{username with access to a protected topic.}

\item{password}{password with access to a protected topic.}

\item{...}{other arguments passed to \code{\link[=ntfy_send]{ntfy_send()}}}
}
\value{
The input \code{x} (for further piping). A notification will be sent as a
side-effect.
}
\description{
\code{ntfy_done()} tells you when the code completed, and
\code{ntfy_done_with_timing()} tells you how long it took.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# report that a process has completed
Sys.sleep(3) |> ntfy_done("Woke up")

# report that a process has completed, and how long it took
Sys.sleep(3) |> ntfy_done_with_timing()
\dontshow{\}) # examplesIf}
}
