% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KernelRetrieval.R
\name{KernelRetrieval}
\alias{KernelRetrieval}
\title{The helper function for retrieving a kernel function and its associated statistics.}
\usage{
KernelRetrieval(name)
}
\arguments{
\item{name}{The lower-case full name of the kernel function.}
}
\value{
A list that contains three elements.
\item{KernFunc}{The interested kernel function.}
\item{sigmaK_sq}{The second moment of the kernel function.}
\item{K_sq}{The variance of the kernel function.}
}
\description{
This function helps retrieve the commonly used kernel function, its second moment,
and its variance based on the name.
}
\examples{
\donttest{
  kernel_result <- KernelRetrieval("epanechnikov")
  kernT <- kernel_result$KernFunc
  sigmaK_sq <- kernel_result$sigmaK_sq
  K_sq <- kernel_result$K_sq
}

}
\author{
Yikun Zhang, \email{yikunzhang@foxmail.com}
}
\keyword{and}
\keyword{associated}
\keyword{function}
\keyword{its}
\keyword{kernel}
\keyword{retrieve}
\keyword{statistics}
