% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/047_sym_nexc_ln.R
\name{sym_nexc_ln}
\alias{sym_nexc_ln}
\alias{sym_nexc_ln.default}
\alias{sym_nexc_ln.formula}
\title{Symmetric next-class label noise}
\usage{
\method{sym_nexc_ln}{default}(x, y, level, order = levels(y), sortid = TRUE, ...)

\method{sym_nexc_ln}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a factor vector with the output class of each sample.}

\item{level}{a double in [0,1] with the noise level to be introduced.}

\item{order}{a character vector indicating the order of the classes (default: \code{levels(y)}).}

\item{sortid}{a logical indicating if the indices must be sorted at the output (default: \code{TRUE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output class and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
An object of class \code{ndmodel} with elements:
\item{xnoise}{a data frame with the noisy input attributes.}
\item{ynoise}{a factor vector with the noisy output class.}
\item{numnoise}{an integer vector with the amount of noisy samples per class.}
\item{idnoise}{an integer vector list with the indices of noisy samples.}
\item{numclean}{an integer vector with the amount of clean samples per class.}
\item{idclean}{an integer vector list with the indices of clean samples.}
\item{distr}{an integer vector with the samples per class in the original data.}
\item{model}{the full name of the noise introduction model used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}
}
\description{
Introduction of \emph{Symmetric next-class label noise} into a classification dataset.
}
\details{
The \emph{Symmetric next-class label noise} introduction model randomly selects (\code{level}·100)\% of the samples
in the dataset with independence of their class. Then, the labels of these samples are 
replaced by the next class label according to \code{order}.
}
\note{
Noise model adapted from the papers in References
}
\examples{
# load the dataset
data(iris2D)

# usage of the default method
set.seed(9)
outdef <- sym_nexc_ln(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)], 
                      level = 0.1, order = c("virginica", "setosa", "versicolor"))

# show results
summary(outdef, showid = TRUE)
plot(outdef)

# usage of the method for class formula
set.seed(9)
outfrm <- sym_nexc_ln(formula = Species ~ ., data = iris2D, 
                      level = 0.1, order = c("virginica", "setosa", "versicolor"))

# check the match of noisy indices
identical(outdef$idnoise, outfrm$idnoise)

}
\references{
S. Gehlot, A. Gupta, and R. Gupta. 
\strong{A CNN-based unified framework utilizing projection loss in unison with 
label noise handling for multiple Myeloma cancer diagnosis}. 
\emph{Medical Image Analysis}, 72:102099, 2021.
\doi{10.1016/j.media.2021.102099}.
}
\seealso{
\code{\link{sym_dia_ln}}, \code{\link{sym_pes_ln}}, \code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
