% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndmodel.R
\name{print.ndmodel}
\alias{print.ndmodel}
\title{Print function for class ndmodel}
\usage{
\method{print}{ndmodel}(x, ...)
}
\arguments{
\item{x}{an object of class \code{ndmodel}.}

\item{...}{other options to pass to the function.}
}
\value{
This function does not return any value.
}
\description{
This method displays the basic information about the noise
introduction process contained in an object of class \code{ndmodel}.
}
\details{
This function presents the basic information of the noise introduction process and the resulting noisy dataset contained in the object \code{x} of class \code{ndmodel}.
The information offered is as follows:
\itemize{
   \item the name of the noise introduction model.
   \item the parameters associated with the noise model.
   \item the number of noisy and clean samples in the dataset.
}
}
\examples{
# load the dataset
data(iris2D)

# usage of the default method
set.seed(9)
outdef <- sym_uni_ln(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)], level = 0.1)

# show results
print(outdef)

}
\seealso{
\code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}, \code{\link{sym_uni_ln}}, \code{\link{sym_cuni_ln}}, \code{\link{sym_uni_an}}
}
