% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/002_asy_spa_ln.R
\name{asy_spa_ln}
\alias{asy_spa_ln}
\alias{asy_spa_ln.default}
\alias{asy_spa_ln.formula}
\title{Asymmetric sparse label noise}
\usage{
\method{asy_spa_ln}{default}(x, y, levelO, levelE, order = levels(y), sortid = TRUE, ...)

\method{asy_spa_ln}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a factor vector with the output class of each sample.}

\item{levelO}{a double with the noise level in [0,1] to be introduced into each odd class.}

\item{levelE}{a double with the noise level in [0,1] to be introduced into each even class.}

\item{order}{a character vector indicating the order of the classes (default: \code{levels(y)}).}

\item{sortid}{a logical indicating if the indices must be sorted at the output (default: \code{TRUE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output class and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
An object of class \code{ndmodel} with elements:
\item{xnoise}{a data frame with the noisy input attributes.}
\item{ynoise}{a factor vector with the noisy output class.}
\item{numnoise}{an integer vector with the amount of noisy samples per class.}
\item{idnoise}{an integer vector list with the indices of noisy samples.}
\item{numclean}{an integer vector with the amount of clean samples per class.}
\item{idclean}{an integer vector list with the indices of clean samples.}
\item{distr}{an integer vector with the samples per class in the original data.}
\item{model}{the full name of the noise introduction model used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}
}
\description{
Introduction of \emph{Asymmetric sparse label noise} into a classification dataset.
}
\details{
\emph{Asymmetric sparse label noise} randomly selects (\code{levelO}·100)\% of the samples
in each odd class and (\code{levelE}·100)\% of the samples
in each even class -the order of the class labels is determined by
\code{order}. Then, each odd class is flipped to the next class, whereas each even class
is flipped to the previous class. If the dataset has an odd number of classes, the last class is not corrupted.
}
\note{
Noise model adapted from the papers in References.
}
\examples{
# load the dataset
data(iris2D)

# usage of the default method
set.seed(9)
outdef <- asy_spa_ln(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)], 
                       levelO = 0.1, levelE = 0.3, order = c("virginica", "setosa", "versicolor"))

# show results
summary(outdef, showid = TRUE)
plot(outdef)

# usage of the method for class formula
set.seed(9)
outfrm <- asy_spa_ln(formula = Species ~ ., data = iris2D, 
                        levelO = 0.1, levelE = 0.3, order = c("virginica", "setosa", "versicolor"))

# check the match of noisy indices
identical(outdef$idnoise, outfrm$idnoise)

}
\references{
J. Wei and Y. Liu. 
\strong{When optimizing f-divergence is robust with label noise}. 
In \emph{Proc. 9th International Conference on Learning Representations}, pages 1-11, 2021.
url:\url{https://openreview.net/forum?id=WesiCoRVQ15}.
}
\seealso{
\code{\link{mind_bdir_ln}}, \code{\link{fra_bdir_ln}}, \code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
